/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.CryptoUtil;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasEmpAccountDao;
import com.guochuang.imp.base.dao.BasEmpDao;
import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.ImUser;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="BasEmpService")
@Transactional
public class BasEmpService {
    public static Logger loger = Logger.getLogger(BasEmpService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    SQLManager sqlManager;
    @Autowired
    private BasEmpDao basEmpDao;
    @Autowired
    private BasEmpAccountDao empAccountDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;

    public Object pageall(Long orgid, Long deptid, String search, Integer page, Integer rows) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select DISTINCT t.*,d.DIC_TEXT IS_APP_TEXT_,case when t.status='03' then '\u6ce8\u9500' else '\u542f\u7528' end STATUS_TEXT_,\n( SELECT group_concat( p.post_name ) FROM hr_post p ,\n\t(SELECT 1 AS n union SELECT 2 AS n union SELECT 3 AS n union SELECT 4 AS n  union SELECT 5 AS n) x \n\tWHERE   p.post_id = SUBSTRING_INDEX(SUBSTRING_INDEX(h.present_job, ',', n), ',', -1)\n\tand  n <= (LENGTH(h.present_job) - LENGTH(REPLACE(h.present_job, ',', '')) + 1)\n\t) AS present_job_text_,ifnull((select GROUP_CONCAT(z.org_dept_name) from (\n select DISTINCT CONCAT(bo.ABBR,'.',bd.DEPT_NAME)  org_dept_name from bas_emp_account aa\n  left join bas_dept bd on bd.DEPT_ID = aa.DEPT_ID \n left join bas_org bo on bo.ORG_ID = aa.org_id where aa.EMP_ID = t.emp_id and aa.is_use = 'Y' )z),concat(c.abbr,'.',a.abbr)) AS org_dept_name,\n DATE_FORMAT(t.lock_time,'%Y-%m-%d %H:%i:%s') as locktime ,a.abbr dept_name,c.abbr org_name,h.sex,h.PHOTO_VERSION_ID from bas_emp t\n left join bas_dept a on a.dept_id=t.dept_id\n left join bas_org c on c.org_id=t.org_id\n left join bas_dic d on d.dic_value=t.is_app and d.dic_code= 'IS_USE'\n left join hr_emp h on h.hr_emp_id=t.hr_emp_id\n        where t.is_use='Y'");
        params.put("orgid", orgid);
        sql.append(" and t.org_id in (with recursive org as (select m.* from BAS_ORG m where m.ORG_ID =:orgid  and m.is_use='Y'  union all select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y') select  t.ORG_ID   from org t ) ");
        if (deptid != null) {
            sql.append(" and t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id =:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t)   ");
            params.put("deptid", deptid);
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (upper(t.emp_name) like :search or upper(t.login_name) like :search)  \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by c.SORT, a.display_No, t.display_no");
        PageObject pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        return pageobject;
    }

    public Object findDBOne(Long id) {
        String sql = "select t.*,DATE_FORMAT(t.lock_time,'%Y-%m-%d %H:%i:%s') as locktime ,a.abbr dept_name,c.abbr org_name from bas_emp t  left join bas_dept a on a.dept_id=t.dept_id  left join bas_org c on c.org_id=t.org_id where t.is_use='Y' and t.emp_id=?1";
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("SEX", "SEX");
        dicmapper.put("STATUS", "USER_STATUS");
        dicmapper.put("WORKSTATION", "POSITION_NAME");
        Object o = this.sqlHelper.getSingalMap(sql, new Object[]{id});
        return this.commonService.fmtListWithDic(o, dicmapper);
    }

    public BasEmp findEmpByempId(Long empId) {
        return this.basEmpDao.findById(empId).orElse(new BasEmp());
    }

    public BasEmp findByEmpCode(String empCode) {
        return this.basEmpDao.findByEmpCodeAndIsUse(empCode, "Y");
    }

    public BasEmp findByEmpName(String empName) {
        return this.basEmpDao.findByEmpNameAndIsUse(empName, "Y");
    }

    public BasEmp saveEmp(BasEmp baseEmp) {
        return (BasEmp)this.basEmpDao.save(baseEmp);
    }

    public boolean delEmp(String empId) {
        Long searchEmpId = Long.parseLong(empId);
        BasEmp basEmp = this.findEmpByempId(searchEmpId);
        if (basEmp != null) {
            basEmp.setIsUse("N");
            this.saveEmp(basEmp);
            List<BasEmpAccount> empAccountList = this.empAccountDao.findByEmpIdAndIsUse(searchEmpId, "Y");
            if (!empAccountList.isEmpty()) {
                for (BasEmpAccount empAccount : empAccountList) {
                    empAccount.setIsUse("N");
                    this.empAccountDao.save(empAccount);
                }
            }
        }
        return true;
    }

    public boolean cancelEmp(String empId) {
        Long searchEmpId = Long.parseLong(empId);
        BasEmp basEmp = this.findEmpByempId(searchEmpId);
        if (basEmp != null) {
            basEmp.setStatus("03");
            this.saveEmp(basEmp);
        }
        return true;
    }

    public BasEmp findByloginName(String loginName) {
        return this.basEmpDao.findByloginNameAndIsUse(loginName, "Y");
    }

    public BasEmp findByloginNameOrEmpCode(String loginName) {
        BasEmp emp = this.basEmpDao.findByloginNameAndIsUse(loginName, "Y");
        if (emp != null) {
            return emp;
        }
        List<BasEmp> list = this.bSqlHelper.getList("base.BasEmp.getByEmpCode", MapUtil.of((Object)"empCode", (Object)loginName), BasEmp.class);
        if (!list.isEmpty()) {
            emp = list.get(0);
        }
        if (!(list = this.bSqlHelper.getList("base.BasEmp.getByEmpMobile", MapUtil.of((Object)"mobilephone", (Object)loginName), BasEmp.class)).isEmpty()) {
            emp = list.get(0);
        }
        return emp;
    }

    public BasEmp findByCaId(String caId) {
        List<BasEmp> list = this.basEmpDao.findByCaIdAndIsUse(caId, "Y");
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List queryAllEmplist() {
        StringBuilder sql = new StringBuilder();
        sql.append("  SELECT t.emp_id,t.emp_name from BAS_EMP  t  where t.IS_USE='Y' ");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
    }

    public List<ImUser> queryAllWebChatUser() {
        List list = this.sqlManager.execute(new SQLReady("SELECT t.emp_id as userCode,t.emp_name as userName,a.ABBR as userDept,b.ABBR as userORG,t.DEPT_ID,t.ORG_ID,t.DISPLAY_NO AS orderNum from BAS_EMP  t \nleft join BAS_DEPT a on t.DEPT_ID=a.DEPT_ID\nleft join BAS_ORG b on t.ORG_ID=B.ORG_ID\nwhere t.IS_USE='Y'\nand t.`status` in ('01','02')"), ImUser.class);
        return list;
    }

    public boolean hasloginName(String loginname, Long empid) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from bas_emp t where t.login_name =?1 and t.is_use='Y' ");
        if (empid != null) {
            sql.append(" and t.emp_id <> " + empid);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{loginname})).toString()) <= 0L;
    }

    public JsonMsg genEmpXml(Long empId) {
        JsonMsg msg = new JsonMsg();
        return msg;
    }

    public Object pageSMSEmp(Long orgid, Long deptid, String search, Integer page, Integer rows) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select t.EMP_NAME,h.MOBILEPHONE,concat(t.EMP_NAME,'(',h.MOBILEPHONE,')') EMP_ID_TEXT,  \n");
        sql.append("a.abbr dept_name,c.abbr org_name from bas_emp t  left join hr_emp h on h.hr_emp_id=t.hr_emp_id  left join bas_dept a on a.dept_id=t.dept_id  left join bas_org c on c.org_id=t.org_id where t.is_use='Y' ");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (upper(t.emp_name) like :search or upper(t.login_name) like :search or upper(t.mobilephone) like :search)  \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (orgid != null) {
            params.put("orgid", orgid);
            sql.append(" and t.org_id in (with recursive org as (select m.* from BAS_ORG m where m.ORG_ID =:orgid  and m.is_use='Y'  union all select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y') select  t.ORG_ID   from org t ) ");
        }
        if (deptid != null) {
            sql.append(" and t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id =:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t)   ");
            params.put("deptid", deptid);
        }
        sql.append(" order by a.display_no,t.emp_name");
        PageObject pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("SEX", "SEX");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public BasEmp findByMobilephone(String mobilephone) {
        List<BasEmp> list = this.basEmpDao.findByMobilephoneAndIsUse(mobilephone, "Y");
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public PageObject pageInnerEmp(String search, Long orgId, Long deptId, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(orgId)) {
            params.put("orgId", orgId);
        }
        if (!StringUtil.isEmpty(deptId) && deptId != 0L) {
            params.put("deptId", deptId);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasEmp.select", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("orgName", MemCache.getOrgName(StringUtil.strToLong(map.get("orgId"))));
            map.put("deptName", MemCache.getDeptName(StringUtil.strToLong(map.get("deptId"))));
            List presentJobList = new ArrayList();
            if (map.get("presentJob") != null && StrUtil.isNotEmpty((CharSequence)map.get("presentJob").toString())) {
                String presentJob = map.get("presentJob").toString();
                presentJobList = StrUtil.split((CharSequence)presentJob, (char)',');
            }
            map.put("presentJobList", presentJobList);
        }
        return pageObject;
    }

    public BasEmp findByHrEmpId(Long hrEmpId) {
        return this.basEmpDao.findByHrEmpIdAndIsUse(hrEmpId, "Y");
    }

    public Object queryByName(Long orgId, Long deptId, String empName, String showCancel) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("deptId", deptId);
        if (!StringUtils.isEmpty((String)empName)) {
            params.put("empName", "%" + empName.toUpperCase() + "%");
        }
        params.put("showCancel", showCancel);
        return this.bSqlHelper.getMapList("base.BasEmp.queryByName", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmpDebtOrg() {
        int i = 0;
        int j = 0;
        int k = 0;
        try {
            i = this.bSqlHelper.updateOrDelete("base.BasEmp.updateLjdpOrg", null);
            j = this.bSqlHelper.updateOrDelete("base.BasEmp.updateLjdpDept", null);
            k = this.bSqlHelper.updateOrDelete("base.BasEmp.updateLjdpEmp", null);
        }
        catch (Exception e) {
            try {
                loger.debug((Object)("" + e.getMessage()));
            }
            catch (Throwable throwable) {
                String info = String.format("\u540c\u6b65\u57fa\u7840\u6570\u636e\u6210\u529f\uff0c\u66f4\u65b0\uff08\u5220\u9664\u518d\u63d2\u5165\u7b972\u6b21\u64cd\u4f5c\uff09\u6216\u521b\u5efa\u5355\u4f4d\uff081\u6b21\u64cd\u4f5c\uff09%d\u6b21,\u90e8\u95e8%d\u6b21,\u4eba\u5458\u8d26\u5957%d\u6b21", i, j, k);
                loger.info((Object)info);
                throw throwable;
            }
            String info = String.format("\u540c\u6b65\u57fa\u7840\u6570\u636e\u6210\u529f\uff0c\u66f4\u65b0\uff08\u5220\u9664\u518d\u63d2\u5165\u7b972\u6b21\u64cd\u4f5c\uff09\u6216\u521b\u5efa\u5355\u4f4d\uff081\u6b21\u64cd\u4f5c\uff09%d\u6b21,\u90e8\u95e8%d\u6b21,\u4eba\u5458\u8d26\u5957%d\u6b21", i, j, k);
            loger.info((Object)info);
        }
        String info = String.format("\u540c\u6b65\u57fa\u7840\u6570\u636e\u6210\u529f\uff0c\u66f4\u65b0\uff08\u5220\u9664\u518d\u63d2\u5165\u7b972\u6b21\u64cd\u4f5c\uff09\u6216\u521b\u5efa\u5355\u4f4d\uff081\u6b21\u64cd\u4f5c\uff09%d\u6b21,\u90e8\u95e8%d\u6b21,\u4eba\u5458\u8d26\u5957%d\u6b21", i, j, k);
        loger.info((Object)info);
    }

    public void changeOaPassword(String empNo, String newPassword) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empNo", empNo);
        params.put("newPassword", CryptoUtil.encryptPassword(newPassword));
        this.bSqlHelper.updateOrDelete("base.BasEmp.changeOaPassword", params);
    }
}

