/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasEmpAccountDao;
import com.guochuang.imp.base.dao.BasEmpDao;
import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.base.service.MemCacheService;
import com.guochuang.imp.sys.util.ListUtils;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="BasEmpAccountService")
@Transactional
public class BasEmpAccountService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BasEmpDao basEmpDao;
    @Autowired
    private MemCacheService memCacheService;

    public String queryEmpAccountById(String accountId) {
        if (StringUtils.isBlank((String)accountId)) {
            return null;
        }
        String[] ids = accountId.split(",");
        String accountName = "";
        for (String id : ids) {
            BasEmpAccount account = this.findEmpAccountById(Long.parseLong(id.trim()));
            if (account == null) continue;
            accountName = accountName + "," + account.getAccountName();
        }
        if (StringUtils.isNotBlank((String)accountName)) {
            accountName = accountName.substring(1);
        }
        return accountName;
    }

    public List findBDAccountList(Long empid) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT T.*,A.ORG_NAME,B.DEPT_NAME FROM BAS_EMP_ACCOUNT T LEFT JOIN BAS_ORG A ON A.ORG_ID=T.ORG_ID LEFT JOIN BAS_DEPT B ON B.DEPT_ID=T.DEPT_ID WHERE T.IS_USE='Y' AND T.EMP_ID=?1");
        return this.sqlHelper.queryByNativeSQL(sqlBuilder.toString(), new Object[]{empid}, new int[0]);
    }

    public BasEmpAccount saveBasEmpAccount(BasEmpAccount basEmpAccount) {
        basEmpAccount = (BasEmpAccount)this.basEmpAccountDao.save(basEmpAccount);
        this.memCacheService.setEmpAccountCache();
        return basEmpAccount;
    }

    public String queryEmpAccountByIds(String accountIds) {
        if (StringUtils.isBlank((String)accountIds)) {
            return null;
        }
        String[] ids = accountIds.split(",");
        String accountName = "";
        for (String id : ids) {
            BasEmpAccount account = this.findEmpAccountById(Long.parseLong(id));
            if (account == null) continue;
            accountName = accountName + "," + account.getAccountName();
        }
        if (StringUtils.isNotBlank((String)accountName)) {
            accountName = accountName.substring(1);
        }
        return accountName;
    }

    public boolean delBasEmpAccount(BasEmpAccount basEmpAccount) {
        this.basEmpAccountDao.deleteById(basEmpAccount.getAccountId());
        return true;
    }

    public void delBasEmpAccountByEmpId(Long empId) {
        List<BasEmpAccount> entities = this.findByEmpId(empId);
        for (BasEmpAccount entity : entities) {
            entity.setIsUse("N");
            this.saveBasEmpAccount(entity);
        }
    }

    public BasEmpAccount findEmpAccountById(long empAccountId) {
        BasEmpAccount basEmpAccount = this.basEmpAccountDao.findById(empAccountId).isPresent() ? (BasEmpAccount)this.basEmpAccountDao.findById(empAccountId).get() : null;
        return basEmpAccount;
    }

    public void setEmpAccountDefault(Long empAccountId) {
        BasEmpAccount basEmpAccount = this.findEmpAccountById(empAccountId);
        if (!"Y".equals(basEmpAccount.getIsDefault())) {
            String sql = "update bas_emp_account a set a.is_default='N' where a.account_id<>" + basEmpAccount.getAccountId() + " and a.emp_id=" + basEmpAccount.getEmpId();
            this.sqlHelper.exeNativeSQL(sql);
        }
        basEmpAccount.setIsDefault("Y".equals(basEmpAccount.getIsDefault()) ? "N" : "Y");
        this.saveBasEmpAccount(basEmpAccount);
    }

    public List<BasEmpAccount> findByOrgId(Long orgId) {
        return this.basEmpAccountDao.findByOrgIdAndIsUseOrderByDisplayNoAsc(orgId, "Y");
    }

    public BasEmpAccount getDefaultAccount(Long empId) {
        List<BasEmpAccount> list = this.basEmpAccountDao.findByEmpIdAndIsUse(empId, "Y");
        return list.stream().filter(account -> "Y".equals(account.getIsDefault())).findFirst().orElse(null);
    }

    public Object findByOrgIdsAndDeptIdsAndAccountIds(String search, String orgIds, String deptIds, String accountIds, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String commonSql = "select\n\t t.ACCOUNT_NAME,\n\t t.ACCOUNT_ID,\n\t bo.ORG_NAME as OBS_NAME,\n\t bd.DEPT_NAME,\n\t bo.abbr ,\n\t bd.abbr as dept_abbr,\n\t he.SEX,\n\t he.PHOTO_VERSION_ID,\n\t be.LOGIN_NAME \n from \n\t bas_emp_account t \n left join bas_emp be on \n\t t.EMP_ID = be.EMP_ID \n left join hr_emp he on \n\t he.HR_EMP_ID = be.HR_EMP_ID  left join bas_org bo on \n\t bo.IS_USE = 'Y' \n\t and bo.ORG_ID = t.ORG_ID \n left join bas_dept bd on \n\t bd.IS_USE = 'Y' \n\t and bd.DEPT_ID = t.DEPT_ID ";
        String sqlOrg = commonSql + " where\n\tt.IS_USE = 'Y'\n\tand be.IS_USE = 'Y'\n\tand he.IS_USE = 'Y'\n\tand be.EMP_ID is not null\n\tand he.HR_EMP_ID is not null\tand locate(concat(',', t.ORG_ID, ',') , '," + orgIds + ",') > 0";
        String sqlDept = commonSql + " where\n\tt.IS_USE = 'Y'\n\tand be.IS_USE = 'Y'\n\tand he.IS_USE = 'Y'\n\tand be.EMP_ID is not null\n\tand he.HR_EMP_ID is not null\tand locate(concat(',', t.DEPT_ID, ',') , '," + deptIds + ",') > 0";
        String sqlAccount = commonSql + " where\n\tt.IS_USE = 'Y'\n\tand be.IS_USE = 'Y'\n\tand he.IS_USE = 'Y'\n\tand be.EMP_ID is not null\n\tand he.HR_EMP_ID is not null\tand locate(concat(',', t.ACCOUNT_ID, ',') , '," + accountIds + ",') > 0";
        String sqlWhere = " where 1=1\nand(\n upper(z.ACCOUNT_NAME) like " + search + "  ESCAPE '/'  or \n upper(z.LOGIN_NAME) like " + search + "  ESCAPE '/' \n)";
        String unionAllSql = " select z.* from (" + sqlOrg + " union " + sqlDept + " union " + sqlAccount + " )z " + (StringUtil.isNotEmpty(search) ? sqlWhere : "");
        return this.sqlHelper.pagerNativeSQL(unionAllSql, params, (Integer)page, (Integer)rows);
    }

    public List<Map<String, Object>> findByOrgIds(String orgIds) {
        String sql = "select\n\t*\nfrom\n\tbas_emp_account t\nwhere\n\tt.IS_USE = 'Y'\n\tand locate(concat(',', t.ORG_ID, ',') , '," + orgIds + ",') > 0";
        return this.sqlHelper.queryByNativeSQL(sql, List.class, new int[0]);
    }

    public List findByOrgOrBizIdnew(Long bizId, String search) {
        String sql = "with recursive temp as(\n\t select a.* from view_bas_org_dept a where  a.id =" + bizId + "  \n\t union all\n\t select a.* from view_bas_org_dept a,temp t where t.id=a.pid  )select a.*,GETDEPTNAME(a.dept_id) DEPT_NAME,GETORGNAME(a.ORG_ID) ORG_NAME\n\t\t\t\t  from bas_emp_account a \n\t\t\t\t  left join  bas_emp e on a.emp_id = e.emp_id \n\t\t\t\t  left join  bas_dept d on d.dept_id = a.dept_id \n\t\t\t\t  left join  hr_emp h on h.hr_emp_id = e.hr_emp_id \n\t\t\t\t where a.is_use = 'Y' \n";
        if (!StringUtils.isEmpty((String)search)) {
            search = "'%" + search.toUpperCase() + "%'";
            sql = sql + "and(\n upper(a.ACCOUNT_NAME) like " + search + "  ESCAPE '/' \n)";
        }
        sql = sql + "\t\t\t\t   and exists (select 1 \n\t\t\t\t          from temp d \n\t\t\t\t         where (d.id = a.dept_id or d.id = a.org_id)  ) order by d.display_no,h.ORDER_NUM";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return list;
    }

    public List<BasEmpAccount> findByOrgOrBizId(Long bizId) {
        String sql = "with recursive temp as(\n\t select a.* from view_bas_org_dept a where  a.id =" + bizId + "  \n\t union all\n\t select a.* from view_bas_org_dept a,temp t where t.id=a.pid  )select a.*\n\t\t\t\t  from bas_emp_account a \n\t\t\t\t  left join  bas_emp e on a.emp_id = e.emp_id \n\t\t\t\t  left join  bas_dept d on d.dept_id = a.dept_id \n\t\t\t\t  left join  hr_emp h on h.hr_emp_id = e.hr_emp_id \n\t\t\t\t where a.is_use = 'Y' \n\t\t\t\t   and exists (select 1 \n\t\t\t\t          from temp d \n\t\t\t\t         where (d.id = a.dept_id or d.id = a.org_id)  ) order by   IFNULL(a.org_id,9999999),\n\tIFNULL(d.display_no,9999999),\n\tIFNULL(h.ORDER_NUM,9999999)";
        List list = this.sqlHelper.queryByNativeSQL(sql, BasEmpAccount.class, new int[0]);
        return list;
    }

    public List<BasEmpAccount> findByDeptId(Long deptId) {
        return this.basEmpAccountDao.findByDeptIdAndIsUseOrderByDisplayNoAsc(deptId, "Y");
    }

    public List<BasEmpAccount> findByDeptIds(String deptIds) {
        String sql = "select\n\t*\nfrom\n\tbas_emp_account t\nwhere\n\tt.IS_USE = 'Y'\n\tand locate(concat(',', t.DEPT_ID, ',') , '," + deptIds + ",') > 0";
        return this.sqlHelper.queryByNativeSQL(sql, BasEmpAccount.class, new int[0]);
    }

    public List<BasEmpAccount> findEmpAccountByEmpId(Long empId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,a.emp_name,b.org_name,c.dept_name from bas_emp_account t left join bas_emp a on t.emp_id=a.emp_id  left join bas_org b on t.org_id=b.org_id  left join bas_dept c on t.dept_id=c.dept_id where t.is_use='Y' and t.emp_id= ?1 order by t.display_no");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{empId}, new int[0]);
    }

    public List<BasEmpAccount> findAllEmpAccountList() {
        return this.basEmpAccountDao.findByIsUseOrderByDisplayNoAsc("Y");
    }

    public List<BasEmpAccount> findByEmpId(long empid) {
        return this.basEmpAccountDao.findByEmpIdAndIsUse(empid, "Y");
    }

    public BasEmpAccount findByDDId(String accountName) {
        BasEmpAccount bea = null;
        StringBuilder sql = new StringBuilder();
        String sqlu = "select t.reserve_user1,t.rtx_user from BAS_EMP_ACCOUNT t where t.account_name='" + accountName + "'";
        sql.append(sqlu);
        bea = (BasEmpAccount)this.sqlHelper.getSingal(sqlu);
        return bea;
    }

    public BasEmpAccount findById(long accountid) {
        Optional opt = this.basEmpAccountDao.findById(accountid);
        if (opt.isPresent()) {
            return (BasEmpAccount)this.basEmpAccountDao.findById(accountid).get();
        }
        return new BasEmpAccount();
    }

    public BasEmpAccount findByAccountId(Long accountId) {
        return this.basEmpAccountDao.findByAccountIdAndIsUse(accountId, "Y");
    }

    public List findAccountByEmpId(long empid) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,\n       e.emp_name  as EMP_NAME,\n       o.abbr      as OBS_NAME,\n       d.dept_name as DEPT_NAME\n  from bas_emp_account t\n  left join bas_emp e\n    on e.emp_id = t.emp_id\n  left join bas_org o\n    on o.org_id = t.org_id\n  left join bas_dept d\n    on d.dept_id = t.dept_id\n where t.emp_id = ?1\n   and t.is_use = 'Y' order by case when t.IS_DEFAULT= 'Y' then 0 else 1 end \n");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{empid}, new int[0]);
    }

    public List<ComBoxTreeNode> getOnlineUserObsTree(List<Long> accountIdList, long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tT.OBS_ID ID,\t\t\tNUM.COUNT_NUM,\t\t\tT .OBS_NAME AS TEXT,\t\t\t(SELECT DECODE(COUNT(1), 0, 'open', 'closed') FROM PRE_OBS \t\t\t\tWHERE POBS_ID = T.OBS_ID AND IS_USE = 'Y') AS STATE  FROM \tPRE_OBS T LEFT JOIN ( \t\t\tSELECT \tCOUNT (A .ACCOUNT_ID) AS COUNT_NUM,O.OBS_ID  \t\t\tFROM \tBAS_EMP_ACCOUNT A,PRE_OBS O    \t\t\tWHERE \tO.OBS_ID = A .OBS_ID AND A .IS_USE = 'Y'    \t \t\t\tAND\tA.ACCOUNT_ID IN (?1)    \t\t\t\tAND (O .OBS_ID = ?2  OR O .OBS_ID IN (   \t\t\t\t\t\tSELECT \tB.OBS_ID FROM PRE_OBS B    \t\t\t\t\t\tWHERE\tB.IS_USE='Y' START WITH B.POBS_ID =?2    \t\t\t\t\t\tCONNECT BY PRIOR B.OBS_ID = B.POBS_ID ))\t\t\t   GROUP BY O.OBS_ID \t\t\t\t) NUM       ON \tNUM.OBS_ID = T .OBS_ID  WHERE\tT.IS_USE='Y'  \tAND T.POBS_ID =?2 ORDER BY T.OBS_TYPE, T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{accountIdList, id}, new int[0]);
        return CommTreeUtils.listToNodeList(list);
    }

    public List getOnlineUserList(List<Long> accountIdList, Long orgid, Long deptid) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT T.ACCOUNT_ID, T.ACCOUNT_NAME, A.DEPT_NAME,r.EMP_ID\n  FROM bas_emp r\n  left join BAS_EMP_ACCOUNT t\n    on r.emp_id = t.emp_id\n  left join bas_org o\n    on r.org_id = o.org_id\n  LEFT JOIN BAS_DEPT A\n    ON r.dept_id = A.DEPT_ID\n WHERE T.ACCOUNT_ID IN :accountIdList\n   AND T.IS_USE = 'Y'\n   and r.emp_id <> :adminEmpId \n");
        params.put("accountIdList", accountIdList);
        params.put("adminEmpId", SysContent.EMP_ID_SUPER_ADMIN);
        if (orgid != null) {
            sql.append(" and t.org_id in ( WITH RECURSIVE temp AS (  SELECT\n\t o.* \n FROM\n\tbas_org o WHERE o.org_id = :orgid \n\tUNION ALL\nSELECT\n\t o.* \nFROM\n\t bas_org o ,\n\t\t temp t \n\t WHERE\n\t\t t.org_id = o.porg_id \n\t) SELECT\n\t temp.org_id\n FROM\n\t temp ) \n");
            params.put("orgid", orgid);
        }
        if (deptid != null) {
            sql.append(" and t.dept_id = :deptid \n");
            params.put("deptid", deptid);
        }
        sql.append(" order by o.sort is null,o.sort,a.display_no is null , a.display_no, r.display_no is null, r.display_no  ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        list.stream().forEach(o -> {
            Map map = (Map)o;
            Long accountId = Long.parseLong(map.get("ACCOUNT_ID").toString());
            LoginUser user = CommonService.getLoginUserById(accountId);
            if (user != null) {
                map.put("platform", user.getPlatform());
            }
        });
        return list;
    }

    public Object pageall(String filterDeptIds, Long orgidNew, Long orgid, Long deptid, Long processinstid, String toActId, String isCopy, String formCode, String search, int page, int rows, String isViceStation, String roleId, String isHaveOrgAndRole, String showVisual, String accountId, String isSort, String selectPerson, String notInAccountId) {
        if (orgid == null) {
            orgid = orgidNew;
        }
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (orgid != null && !"Y".equals(isViceStation)) {
            sql.append(" WITH RECURSIVE temp AS (\n\tSELECT\n\t\to.* \n\tFROM\n\t\tBAS_ORG o \n\tWHERE\n\t\to.is_use = 'Y' \n\t\tAND o.ORG_ID=:orgid UNION ALL\n\tSELECT\n\t\tb.* \n\tFROM\n\t\tBAS_ORG b,\n\t\ttemp t \n\tWHERE\n\t\tt.ORG_ID = b.PORG_ID \n\t) ");
            params.put("orgid", orgid);
        }
        sql.append("\nselect t.account_id,\n       t.account_name,\n       t.dept_id,\n       t.display_no,\n       t.emp_id,\n       t.is_use,\n       t.org_id,\n       t.font_size,\n       t.menu_style,\n       t.themes,\n       e.emp_code,\n       e.emp_name,\n       e.login_name,\n       h.hr_emp_id,\n       h.order_num,\n       h.sex,\n       h.photo_Version_Id,\n       h.NATION,\n       h.NATIVE_PLACE,\n       h.BIRTHDAY,\n       h.TOP_EDUCATION,\n       h.RANK_LEVEL,\n       h.RANK,\n       h.WORK_DATE,\n");
        sql.append("       (select group_concat(p.post_name) from hr_post p where  find_in_set(p.POST_ID,h.PRESENT_JOB)>0) PRESENT_JOB_TEXT_,\n");
        sql.append("       h.vice_station,\n");
        if ("Y".equals(isViceStation)) {
            sql.append("\t(\nSELECT\n\tGROUP_CONCAT(concat(m.post_name,'(',(select d.dept_name from bas_dept d where d.dept_id =  m.DEPT_ID),')')) \nFROM\n\thr_post m \nWHERE  find_in_set(m.POST_ID,h.vice_station)>0) vice_station_text_,\n");
        }
        sql.append("       e.status,\n       h.present_job,\n       t2.abbr as obs_name,\n       d.dept_name,\n\t\th.mobilephone,\n       h.telephone,h.ID_CARD ,h.ENTRY_DATE\n  from bas_emp_account t\nleft join bas_emp e\n   on e.emp_id = t.emp_id and e.is_use = 'Y'\n left join hr_emp h on h.hr_emp_id=e.hr_emp_id and h.is_use = 'Y'     left join bas_org t2\n   on t.org_id = t2.org_id\n   left join bas_dept d\n   on  t.dept_id = d.dept_id LEFT JOIN ");
        if ("Y".equals(isViceStation)) {
            sql.append("(\nSELECT\n\te1.hr_emp_id,\n\tgroup_concat( DISTINCT p1.org_id ) AS v_org_id,\n\tgroup_concat( DISTINCT p1.dept_id ) AS v_dept_id \nFROM\n\thr_emp e1\n\tLEFT JOIN hr_post p1 ON instr(\n\t\tconcat( ',', e1.vice_station, ',' ),\n\tconcat( ',', p1.post_id, ',' )) != 0 \n\tAND p1.is_use = 'Y' \nWHERE\n\te1.is_use = 'Y' \nGROUP BY\n\te1.hr_emp_id,\n\te1.org_id,\n\te1.dept_id \n)");
        } else {
            sql.append(" hr_emp ");
        }
        sql.append(" a ON a.hr_emp_id = h.hr_emp_id \n where t.is_use = 'Y' and e.is_use = 'Y'  ");
        if (!"Y".equals(showVisual)) {
            sql.append("and e.status <>'03' ");
        }
        if (orgid != null) {
            if ("Y".equals(isViceStation)) {
                sql.append(" AND (h.org_id in (with recursive org as (select m.* from BAS_ORG m where m.ORG_ID=:orgid  and m.is_use='Y'  union all select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y') select  t.ORG_ID   from org t )  OR instr(concat(',' , a.v_org_id , ','), concat(',' , :orgid  , ',')) != 0 ");
                params.put("orgid", orgid);
                if ("Y".equals(showVisual)) {
                    sql.append(" or t.org_id in (with recursive org as (select m.* from BAS_ORG m where m.ORG_ID=:orgid  and m.is_use='Y'  union all select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y') select  t.ORG_ID   from org t ) ");
                }
                sql.append(")");
            } else {
                sql.append(" and t.org_id in (SELECT\ttemp.org_id FROM temp ) ");
            }
        }
        if (StringUtils.isNotEmpty((String)filterDeptIds)) {
            sql.append(" and t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where find_in_set(m.dept_id,:filterDeptIds)!=0  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t ) ");
            params.put("filterDeptIds", filterDeptIds);
        }
        if (StringUtil.isNotEmpty(selectPerson)) {
            sql.append("and :selectPerson not like concat('%,',t.ACCOUNT_ID,',%') ");
            params.put("selectPerson", "," + selectPerson + ",");
        }
        if (StringUtil.isNotEmpty(notInAccountId)) {
            sql.append("and :notInAccountId not like concat('%,',t.ACCOUNT_ID,',%') ");
            params.put("notInAccountId", "," + notInAccountId + ",");
        }
        if (StringUtil.isNotEmpty(accountId)) {
            sql.append(" and  t.ACCOUNT_ID <> :accountId");
            params.put("accountId", accountId);
        }
        if (deptid != null) {
            if ("Y".equals(isViceStation)) {
                sql.append(" AND (h.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id=:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t) OR instr(concat(',' ,a.v_dept_id , ','),concat( ',' , :deptid , ',')) != 0 ");
                if ("Y".equals(showVisual)) {
                    sql.append(" or t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id=:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t ) ");
                }
                sql.append(")");
                params.put("deptid", deptid);
            } else {
                sql.append(" and t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id=:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t ) ");
                params.put("deptid", deptid);
            }
        }
        if (processinstid != null && StringUtils.isNotBlank((String)toActId)) {
            HashMap<String, Object> formparams = new HashMap();
            try {
                formparams = this.flowUtilService.getFormParams(processinstid, formCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<Long> ids = this.flowUtilService.getNextWFParticipantIds(processinstid, toActId, isCopy, formCode, formparams);
            if (!ids.isEmpty()) {
                sql.append(" and t.account_id in(:accountIds)\n");
                params.put("accountIds", ids);
            }
        }
        if ("Y".equals(isHaveOrgAndRole)) {
            LoginUser loginUser = SysUtils.getLoginUser();
            Long l = loginUser.getOrgid();
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (  upper(e.emp_code) like :search  ");
            sql.append(" or upper(e.emp_name) like :search  ");
            sql.append(" or upper(t.account_name) like :search  ");
            sql.append(" or upper(e.login_name) like :search )");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (StringUtil.isNotEmpty(isSort) && "hr".equals(isSort)) {
            sql.append(" order by h.order_num");
        } else {
            sql.append(" order by t2.sort,d.display_no, e.display_no, e.emp_name");
        }
        PageObject pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        return pageobject;
    }

    public List<BasEmpAccount> getDeptDirector(Long deptId) {
        String sql = "select a.* from bas_emp_account a where a.emp_id in( select e.emp_id from bas_emp e where e.is_use='Y' AND e.workstation='1')";
        if (deptId != null) {
            sql = sql + " and a.dept_id=" + deptId;
        }
        return this.sqlHelper.queryByNativeSQL(sql.toString(), BasEmpAccount.class, new int[0]);
    }

    public List<Long> getDeptWithRole(Long deptId) throws GEPSBisException {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String sql = "select a.account_id\n  from bas_emp_account a\n where a.dept_id = ?1 \n";
        try {
            List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{deptId}, new int[0]);
            if (!list.isEmpty()) {
                for (Object o : list) {
                    Map m = (Map)o;
                    userIds.add(Long.parseLong(m.get("ACCOUNT_ID").toString()));
                }
            }
        }
        catch (Exception e) {
            throw new GEPSBisException("\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u5458\u672a\u627e\u5230", e);
        }
        return userIds;
    }

    public List<BasEmpAccount> getDeptArchive(Long deptId) {
        String sql = "select a.*\n  from bas_emp_account a\n where a.account_id in\n       (select x.account_id from bas_roles_account x where x.role_id = 6)\n   and a.dept_id = ?1";
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{deptId}, BasEmpAccount.class, new int[0]);
    }

    public List<BasEmpAccount> getBasContactOrg(Long accountId) {
        String sql = "select a.*\n  from bas_emp_account a\n where a.account_id in\n       (select x.account_id from bas_roles_account x where x.role_id = 5)\n   and a.dept_id = (select t.dept_id from bas_emp_account t where t.is_use='Y' and ACCOUNT_ID=?1)";
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{accountId}, BasEmpAccount.class, new int[0]);
    }

    public List<BasEmpAccount> getBasAccountByRoleId(Long roleId) {
        String sql = "select a.*\n  from bas_emp_account a\n where a.is_use = 'Y'\n   and a.account_id in\n       (select x.account_id from bas_roles_account x where x.role_id = ?1)";
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{roleId}, BasEmpAccount.class, new int[0]);
    }

    public Map<String, Object> getEmpStatisticsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder sqlBuilder1 = new StringBuilder("select count(*) num1\n  from hr_emp t\n where t.is_use = 'Y'\n");
        Object map1 = this.sqlHelper.getSingal(sqlBuilder1.toString());
        StringBuilder sqlBuilder2 = new StringBuilder("select decode( b.num,0,0, round(a.age/b.num,0)) as num2 --\u5e73\u5747\u5e74\u9f84\n from\n\uff08SELECT sum(TRUNCATE(months_between(sysdate, t.birthday) / 12)) AS age--\u5e74\u9f84\u603b\u5408\u8ba1\n  from HR_EMP t\n where t.is_use = 'Y'\n   and t.birthday is not null\uff09a,\n(SELECT count(*) as num --\u5e74\u9f84\u975e\u7a7a\u7684\u603b\u5408\u8ba1\n  from HR_EMP t\n where t.is_use = 'Y'\n   and t.birthday is not null\uff09b");
        Object map2 = this.sqlHelper.getSingal(sqlBuilder2.toString());
        StringBuilder sqlBuilder3 = new StringBuilder("select count(*) num3\n  from hr_emp t\n where t.is_use = 'Y'\n   and DATE_FORMAT(SYSDATE(),'%Y-%m') = DATE_FORMAT(t.entry_time,'%Y-%m')");
        Object map3 = this.sqlHelper.getSingal(sqlBuilder3.toString());
        StringBuilder sqlBuilder4 = new StringBuilder("select count(*) num4\n  from hr_emp t, HR_LABOR_CONTRACT s\n where t.is_use = 'Y'\n   and t.emp_id = s.emp_id\n   and DATE_FORMAT(SYSDATE(),'%Y-%m') = DATE_FORMAT(s.hrcon_end,'%Y-%m')");
        Object map4 = this.sqlHelper.getSingal(sqlBuilder4.toString());
        map.put("num1", map1);
        map.put("num2", map2);
        map.put("num3", map3);
        map.put("num4", map4);
        return map;
    }

    public List<BasEmpAccount> findByAccountIds(List<Long> accountids) {
        return this.basEmpAccountDao.findByAccountIdInAndIsUse(accountids, "Y");
    }

    public List<BasEmpAccount> findByAccountIds(String accountids) {
        String sql = "select\n\t*\nfrom\n\tbas_emp_account t\nwhere\n\tt.IS_USE = 'Y'\n\tand locate(concat(',', t.ACCOUNT_ID, ',') , '," + accountids + ",') > 0";
        return this.sqlHelper.queryByNativeSQL(sql, BasEmpAccount.class, new int[0]);
    }

    public List<BasEmpAccount> getAccountByPhone(String phone) {
        String sql = "select a.*\n  from bas_emp_account a, bas_emp e, hr_emp h\n where a.IS_USE = 'Y'\n   and a.EMP_ID = e.EMP_ID\n   and e.HR_EMP_ID = h.hr_emp_id\n   and h.mobilephone = ?1";
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{phone}, BasEmpAccount.class, new int[0]);
    }

    public String getAccountNamesByIds(String inspectLeader) {
        String[] ids = inspectLeader.split(",");
        ArrayList<String> names = new ArrayList<String>();
        for (String id : ids) {
            BasEmpAccount bas = this.findEmpAccountById(Long.parseLong(id));
            if (bas == null) continue;
            names.add(bas.getAccountName());
        }
        String accountNames = StringUtils.join(names, (char)',');
        return accountNames;
    }

    public List findEmpAccountByAccountId(Long accountId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,b.org_name,b.abbr,c.dept_name from bas_emp_account t  left join bas_org b on t.org_id=b.org_id  left join bas_dept c on t.dept_id=c.dept_id where t.is_use='Y' and t.account_id= ?1 order by t.display_no");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{accountId}, new int[0]);
    }

    public List<Map<String, Object>> findEmpAccountByAccountIds(String accountIds) {
        Object[] idArr = accountIds.split(",");
        StringBuilder sql = new StringBuilder();
        sql.append("select t.account_id,\n       t.account_name,\n       t.dept_id,\n       t.display_no,\n       t.emp_id,\n       t.is_use,\n       t.org_id,\n       t.font_size,\n       t.menu_style,\n       t.themes,\n       e.emp_code,\n       e.emp_name,\n       e.login_name,\n       h.sex,\n       h.photo_Version_Id,\n       h.vice_station,\n       e.status,\n       h.present_job,\n       t2.abbr as obs_name,\n       d.dept_name,\n\th.mobilephone,\n       h.telephone,h.ID_CARD ,h.ENTRY_DATE\n  from bas_emp_account t\nleft join bas_emp e\n   on e.emp_id = t.emp_id and e.is_use = 'Y'\n left join hr_emp h on h.hr_emp_id=e.hr_emp_id and h.is_use = 'Y'     left join bas_org t2\n   on t.org_id = t2.org_id\n   left join bas_dept d\n   on  t.dept_id = d.dept_id \n where t.is_use = 'Y' and e.is_use = 'Y' \n and t.ACCOUNT_ID = ?1");
        for (int i = 1; i < idArr.length; ++i) {
            sql.append(" UNION ALL (select t.account_id,\n       t.account_name,\n       t.dept_id,\n       t.display_no,\n       t.emp_id,\n       t.is_use,\n       t.org_id,\n       t.font_size,\n       t.menu_style,\n       t.themes,\n       e.emp_code,\n       e.emp_name,\n       e.login_name,\n       h.sex,\n       h.photo_Version_Id,\n       h.vice_station,\n       e.status,\n       h.present_job,\n       t2.abbr as obs_name,\n       d.dept_name,\n\th.mobilephone,\n       h.telephone,h.ID_CARD ,h.ENTRY_DATE\n  from bas_emp_account t\nleft join bas_emp e\n   on e.emp_id = t.emp_id and e.is_use = 'Y'\n left join hr_emp h on h.hr_emp_id=e.hr_emp_id and h.is_use = 'Y'     left join bas_org t2\n   on t.org_id = t2.org_id\n   left join bas_dept d\n   on  t.dept_id = d.dept_id \n where t.is_use = 'Y' and e.is_use = 'Y' \n and t.ACCOUNT_ID = ?" + (i + 1) + ")");
        }
        return this.sqlHelper.queryByNativeSQL(sql.toString(), idArr, new int[0]);
    }

    public BasEmpAccount getByHrEmpId(Long hrEmpId) {
        BasEmp basEmp = this.basEmpDao.findByHrEmpIdAndIsUse(hrEmpId, "Y");
        return this.basEmpAccountDao.findByEmpId(basEmp.getEmpId());
    }

    public List<BasEmpAccount> findByEmpIdAndIsDefault(Long empId, String isDefault) {
        return this.basEmpAccountDao.findByEmpIdAndIsDefaultAndIsUse(empId, isDefault, "Y");
    }

    public List<Map<String, Object>> findEmpByAccountIds(String accountIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)accountIds) && !"null".equals(accountIds)) {
            params.put("accountIds", ListUtils.stringToListWithLong(accountIds));
        }
        return this.bSqlHelper.getMapList("base.BasEmp.findEmpByAccountIds", params);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public List<ComBoxTreeNode> accountOrgTree(Long processinstid, String toActId, String isCopy, String formCode, String particType, String treetype, Long orgId, String type, String showCancel) {
        List<Map<String, Object>> list;
        List<Long> ids;
        LoginUser user = SysUtils.getLoginUser();
        String id = "";
        String pid = "";
        Long curorgId = null;
        String text = "";
        if ("dept".equals(treetype)) {
            text = "\u672c\u90e8\u95e8";
            pid = "dept" + user.getDeptid().toString();
        } else if ("org".equals(treetype)) {
            text = "\u672c\u5355\u4f4d";
            pid = user.getOrgid().toString();
            curorgId = user.getOrgid();
        } else if ("all".equals(treetype)) {
            text = "\u5168\u4f53\u7528\u6237";
            if (orgId != null) {
                id = orgId.toString();
            } else {
                pid = "0";
            }
        } else if ("group".equals(treetype)) {
            text = "\u7ec4\u4fe1\u606f";
            pid = "0";
        }
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId(treetype);
        root.setText(text);
        root.setChecked(false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (curorgId != null) {
            params.put("curorgId", curorgId);
        }
        if (!StringUtils.isEmpty((String)id)) {
            params.put("id", id);
        }
        if (!StringUtils.isEmpty((String)pid)) {
            params.put("pid", pid);
        }
        if (StringUtil.isNotEmpty(type)) {
            // empty if block
        }
        HashMap<String, Object> formparams = new HashMap();
        try {
            formparams = this.flowUtilService.getFormParams(processinstid, formCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (processinstid != null && !(ids = this.flowUtilService.getNextWFParticipantIds(processinstid, toActId, isCopy, formCode, formparams)).isEmpty()) {
            params.put("accountIds", ids.stream().map(i -> "emp" + i.toString()).collect(Collectors.toList()));
        }
        if ("group".equals(treetype)) {
            list = this.bSqlHelper.getMapList("base.BasEmpAccount.accountGroupTree", params);
        } else {
            params.put("particType", particType);
            list = this.bSqlHelper.getMapList("base.BasEmpAccount.accountOrgTree", params);
        }
        root.setChildren(CommTreeUtils.buildTreeNode(list));
        ArrayList<ComBoxTreeNode> rootlist = new ArrayList<ComBoxTreeNode>();
        rootlist.add(root);
        return rootlist;
    }

    public List<BasEmpAccount> getAccountByEmpCode(String empCode) {
        String sql = "select a.*\n  from bas_emp_account a, bas_emp e, hr_emp h\n where a.IS_USE = 'Y'\n   and a.EMP_ID = e.EMP_ID\n   and e.HR_EMP_ID = h.hr_emp_id\n   and h.EMP_CODE = ?1";
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{empCode}, BasEmpAccount.class, new int[0]);
    }
}

