/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasDicTypeDao;
import com.guochuang.imp.base.entity.BasDic;
import com.guochuang.imp.base.entity.BasDicType;
import com.guochuang.imp.base.entity.BasDicVirtual;
import com.guochuang.imp.base.service.BasDicService;
import com.guochuang.imp.base.service.MemCacheService;
import com.guochuang.imp.gen.service.GenFormService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
@Transactional
public class BasDicTypeService {
    private static final Logger logger = Logger.getLogger(GenFormService.class);
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDicTypeDao basdictypeDao;
    @Autowired
    private MemCacheService memCacheService;
    @Autowired
    private BasDicTypeService basDicTypeService;
    @Autowired
    private BasDicService basDicService;

    public BasDicType findBasDicType(Long id) {
        BasDicType entity = (BasDicType)this.basdictypeDao.findById(id).get();
        return entity;
    }

    public BasDicType findByDicCode(String dicCode) {
        return this.basdictypeDao.findByDicCodeAndIsUse(dicCode, "Y");
    }

    @CacheEvict(cacheNames={"DicCache"}, allEntries=true)
    public void saveBasDicType(BasDicType entity) {
        this.basdictypeDao.save(entity);
        this.memCacheService.setDicCache();
    }

    @CacheEvict(cacheNames={"DicCache"}, allEntries=true)
    public void delBasDicType(Long id) {
        BasDicType entity = (BasDicType)this.basdictypeDao.findById(id).get();
        entity.setIsUse("N");
        this.basdictypeDao.save(entity);
    }

    public PageObject PageAll(String search, Long businessTypeId, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (businessTypeId != null) {
            params.put("businessTypeId", businessTypeId);
        }
        return this.bSqlHelper.serachPage("base.dic.pageAllType", params, PageRequest.of((int)page, (int)rows));
    }

    public JsonMsg checkRepeat(BasDicType entity) {
        JsonMsg msg = new JsonMsg();
        List<BasDicType> list1 = this.basdictypeDao.findByDicCodeAndIsUseOrderByDicCode(entity.getDicCode(), "Y");
        List<BasDicType> list2 = this.basdictypeDao.findByDicNameAndIsUse(entity.getDicName(), "Y");
        if (list1.size() > 1 && list2.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u5b57\u5178\u540d\u79f0\u548c\u7f16\u7801\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list1.size() <= 1 && list2.size() <= 1) {
            if (list1.size() <= 1 && list2.size() == 1 && !list2.get(0).getId().equals(entity.getId()) && (list1.size() < 1 || list1.size() == 1 && list1.get(0).getId().equals(entity.getId()))) {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u540d\u79f0\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            }
            if (list1.size() == 1 && list2.size() <= 1 && !list1.get(0).getId().equals(entity.getId()) && (list2.size() < 1 || list2.size() == 1 && list2.get(0).getId().equals(entity.getId()))) {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u7f16\u7801\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            }
            if (list1.size() == 1 && list2.size() == 1 && !list1.get(0).getId().equals(entity.getId()) && !list2.get(0).getId().equals(entity.getId())) {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u540d\u79f0\u548c\u7f16\u7801\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            }
        } else if (list1.size() > 1 && list2.size() <= 1) {
            if (list2.size() == 1 && !list1.get(0).getId().equals(entity.getId())) {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u540d\u79f0\u548c\u7f16\u7801\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            } else {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u7f16\u7801\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            }
        } else if (list2.size() > 1 && list1.size() <= 1) {
            if (list1.size() == 1 && !list1.get(0).getId().equals(entity.getId())) {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u540d\u79f0\u548c\u7f16\u7801\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            } else {
                msg.setSuccess(false);
                msg.setMsg("\u5b57\u5178\u540d\u79f0\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
            }
        }
        return msg;
    }

    public Object pageDicType(String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search + "%");
        }
        return this.bSqlHelper.serachPage("base.dic.pageDicType", params, PageRequest.of((int)page, (int)rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDicTypeXml(String ids, HttpServletResponse response) {
        ArrayList<BasDicVirtual> list = new ArrayList<BasDicVirtual>();
        String title = "";
        String[] idList = ids.split(";");
        int num = idList.length;
        String str = "\u5b57\u5178";
        if (num > 3) {
            num = 3;
            str = "\u7b49\u5b57\u5178";
        }
        for (int i = 0; i < idList.length; ++i) {
            BasDicVirtual basDicVirtual = this.getDicTypeAllInfo(idList[i]);
            list.add(basDicVirtual);
            if (i < num - 1) {
                title = title + basDicVirtual.getDicName() + "\u3001";
            }
            if (i != num - 1) continue;
            title = title + basDicVirtual.getDicName() + str;
        }
        JSONArray json = JSONUtil.parseArray(list);
        ServletOutputStream out = null;
        try {
            response.setContentType("text/plain");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String((title + ".json").getBytes("utf-8"), "iso-8859-1"));
            out = response.getOutputStream();
            out.write(json.toJSONString(1).getBytes());
        }
        catch (Exception var20) {
            String msg = var20.getCause().getMessage();
            if (msg == null || !msg.contains("\u8f6f\u4ef6\u4e2d\u6b62")) {
                logger.error((Object)("\u5b57\u5178ID\uff1a" + ids + "   \u5bfc\u51fa\u5931\u8d25\uff01"));
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException var19) {
                    logger.error((Object)var19);
                }
            }
        }
    }

    public BasDicVirtual getDicTypeAllInfo(String id) {
        BasDicType basDicType = this.basDicTypeService.findBasDicType(Long.parseLong(id));
        BasDicVirtual basDicVirtual = new BasDicVirtual();
        BeanUtils.copyProperties((Object)basDicType, (Object)basDicVirtual);
        List<BasDic> basDicList = this.basDicService.findByDicCode(basDicType.getDicCode());
        basDicVirtual.setDics(basDicList);
        return basDicVirtual;
    }

    public JsonMsg importDicType(String jsonStr) {
        JsonMsg msg = new JsonMsg();
        List list = JSONObject.parseArray((String)jsonStr, BasDicVirtual.class);
        int falseNum = 0;
        ArrayList<String> namelist = new ArrayList<String>();
        for (BasDicVirtual importDic : list) {
            if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{importDic.getId().toString(), importDic.getDicCode()})) {
                ++falseNum;
                namelist.add(importDic.getDicName());
                continue;
            }
            try {
                BasDicType basDicType = new BasDicType();
                BeanUtils.copyProperties((Object)importDic, (Object)basDicType);
                boolean flag = false;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("dicCode", basDicType.getDicCode());
                basDicType.setId(null);
                Map<String, Object> isExitEntity = this.bSqlHelper.getMap("base.dic.getBasDicTypeByParams", params);
                if (!ObjectUtils.isEmpty(isExitEntity)) {
                    flag = true;
                    basDicType.setId((Long)isExitEntity.get("ID"));
                }
                this.basDicTypeService.saveBasDicType(basDicType);
                List<BasDic> dics = importDic.getDics();
                if (dics == null) continue;
                if (flag) {
                    this.bSqlHelper.updateOrDelete("base.dic.deleteBasDic", params);
                }
                for (BasDic b : dics) {
                    b.setTypeId(basDicType.getId());
                    b.setDicId(null);
                    this.basDicService.saveDic(b);
                }
            }
            catch (Exception var11) {
                ++falseNum;
                namelist.add(importDic.getDicName());
            }
        }
        if (falseNum == 0) {
            int successNum = list.size();
            msg.setMsg(successNum + "\u4e2a\u5b57\u5178\u5bfc\u5165\u6210\u529f");
        } else {
            msg.setSuccess(false);
            int successNum = list.size() - falseNum;
            String name = org.apache.commons.lang3.StringUtils.join(namelist, (String)",");
            msg.setMsg(successNum + "\u4e2a\u5b57\u5178\u5bfc\u5165\u6210\u529f\uff0c" + falseNum + "\u4e2a\u5b57\u5178\u5bfc\u5165\u5931\u8d25\uff0c" + name + "\u5bfc\u5165\u5931\u8d25");
        }
        return msg;
    }
}

