/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasAppUpdateDao;
import com.guochuang.imp.base.entity.BasAppUpdate;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasAppUpdateService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasAppUpdateDao basAppUpdateDao;

    public PageObject pageAll(int page, int rows, String sort, String order, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if (!StringUtil.isEmpty(search)) {
            params.put("search", search);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasAppUpdate.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("updateTypeText", MemCache.getDicText("APP_UPDATE_TYPE", StringUtil.null2String(map.get("updateType"))));
        }
        return pageObject;
    }

    @Transactional
    public void saveBasAppUpdate(BasAppUpdate entity) {
        this.basAppUpdateDao.save(entity);
    }

    public BasAppUpdate findBasAppUpdate(Long id) {
        BasAppUpdate entity = (BasAppUpdate)this.basAppUpdateDao.findById(id).get();
        return entity;
    }

    public void delBasAppUpdate(Long id) {
        BasAppUpdate entity = (BasAppUpdate)this.basAppUpdateDao.findById(id).get();
        entity.setIsUse("N");
        this.basAppUpdateDao.save(entity);
    }

    public JSONObject getAppUpdateJson() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Object> data = this.bSqlHelper.getMap("base.BasAppUpdate.getAppUpdateJson", params);
        JSONObject json = new JSONObject();
        if (data != null) {
            json.put("appid", data.get("appid"));
            json.put("appiosid", data.get("appiosid"));
            json.put("isForceUpdate", data.get("isForceUpdate"));
            JSONObject updateJson = new JSONObject();
            updateJson.put("version", data.get("version"));
            updateJson.put("title", data.get("title"));
            updateJson.put("note", data.get("note"));
            updateJson.put("url", data.get("fileUrl"));
            if ("1".equals(data.get("updateType").toString())) {
                JSONObject iosJson = new JSONObject();
                iosJson.putAll((Map)updateJson);
                json.put("iOS", (Object)iosJson);
                json.put("Android", (Object)updateJson);
            } else if ("2".equals(data.get("updateType").toString())) {
                json.put("Android", (Object)updateJson);
            } else if ("3".equals(data.get("updateType").toString())) {
                json.put("iOS", (Object)updateJson);
            }
        }
        return json;
    }

    public Map<String, Object> getDeviceUpdateJson(String type) {
        return "iOS".equals(type) ? this.getIosUpdateInfo() : ("Android".equals(type) ? this.getAndroidUpdateInfo() : this.getDeskUpdateInfo());
    }

    public Map<String, Object> getIosUpdateInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", Arrays.asList("1", "3"));
        return this.bSqlHelper.getMap("base.BasAppUpdate.getDeviceUpdate", params);
    }

    public Map<String, Object> getAndroidUpdateInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", Arrays.asList("1", "2"));
        Map<String, Object> update = this.bSqlHelper.getMap("base.BasAppUpdate.getDeviceUpdate", params);
        Map<String, Object> apk = this.bSqlHelper.getMap("base.BasAppUpdate.getLastApk", params);
        if (apk != null) {
            update.put("apkVersion", apk.get("version"));
            update.put("apkUrl", apk.get("fileUrl"));
            update.put("apkTitle", apk.get("title"));
            update.put("apkNote", apk.get("note"));
        }
        return update;
    }

    public Map<String, Object> getDeskUpdateInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", Arrays.asList("4"));
        return this.bSqlHelper.getMap("base.BasAppUpdate.getDeviceUpdate", params);
    }
}

