/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.exceltools.ExcelUtils;
import com.guochuang.imp.base.common.util.exceltools.JsGridReportBase;
import com.guochuang.imp.base.common.util.exceltools.TableData;
import com.guochuang.imp.base.common.util.exceltools.TableHeaderMetaData;
import com.guochuang.imp.config.SysConfigProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/export"})
public class ExportController {
    @RequestMapping(value={"/exportExcel"})
    @ResponseBody
    public void exportExcel(String title, String urlAddress, String heads, String fields, String queryParams, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!StringUtils.isEmpty((Object)heads) && !StringUtils.isEmpty((Object)fields)) {
            JSONObject fieldcombos = JSON.parseObject((String)request.getParameter("fieldcombos"));
            JSONObject expoptions = JSON.parseObject((String)request.getParameter("expoptions"));
            response.setContentType("application/msexcel;charset=GBK");
            String[] headsData = heads.split(",");
            String[] fieldsData = fields.split(",");
            InetAddress addr = InetAddress.getLocalHost();
            String ip = SysConfigProperties.useLocalPath ? "localhost" : addr.getHostAddress().toString();
            String realUrl = "http://" + ip + ":" + request.getLocalPort() + urlAddress;
            JSONArray jsonArray = ExcelUtils.sendHttp(request, response, realUrl, queryParams);
            if (fieldcombos != null) {
                jsonArray.forEach(obj -> {
                    JSONObject jsonObject = (JSONObject)obj;
                    for (String key : fieldcombos.keySet()) {
                        if (!jsonObject.containsKey((Object)key)) continue;
                        JSONArray combos = fieldcombos.getJSONArray(key);
                        combos.forEach(combo -> {
                            JSONObject comboObject = (JSONObject)combo;
                            if (jsonObject.getString(key).equals(comboObject.getString("value"))) {
                                jsonObject.put(key, (Object)comboObject.getString("text"));
                            }
                        });
                    }
                });
            }
            String headTitle = title;
            Boolean showHeadTitle = true;
            TableHeaderMetaData headerMetaData = ExcelUtils.createTableHeader(headsData);
            if (expoptions != null) {
                JSONObject hws;
                if (expoptions.containsKey((Object)"headTitle")) {
                    headTitle = expoptions.getString("headTitle");
                }
                if (expoptions.containsKey((Object)"showHeadTitle")) {
                    showHeadTitle = expoptions.getBoolean("showHeadTitle");
                }
                if ((hws = expoptions.getJSONObject("colWidths")) != null) {
                    List<String> headers = Arrays.asList(fieldsData);
                    hws.forEach((key, value) -> {
                        if (headers.indexOf(key) != -1) {
                            headerMetaData.getColumns().get(headers.indexOf(key)).setWidth(Integer.parseInt(value.toString()));
                        }
                    });
                }
            }
            TableData td = ExcelUtils.createTableData(jsonArray, headerMetaData, fieldsData);
            JsGridReportBase report = new JsGridReportBase(request, response);
            report.exportToExcel(title, "admin", td, showHeadTitle, headTitle);
        }
    }

    @RequestMapping(value={"/exportSpanExcel"})
    @ResponseBody
    public void exportSpanExcel(String title, String urlAddress, String heads, String fields, String queryParams, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!StringUtils.isEmpty((Object)heads) && !StringUtils.isEmpty((Object)fields)) {
            JSONObject fieldcombos = JSON.parseObject((String)request.getParameter("fieldcombos"));
            JSONObject expoptions = JSON.parseObject((String)request.getParameter("expoptions"));
            response.setContentType("application/msexcel;charset=GBK");
            String[] headsData = heads.split(",");
            String[] headParents = new String[headsData.length];
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (int i = 0; i < headsData.length; ++i) {
                String[] headParent = headsData[i].split(":");
                headParents[i] = headParent[0];
                if (headParent == null || headParent.length <= 1) continue;
                String[] headChild = headParent[1].split(";");
                map.put(headParent[0], headChild);
            }
            String[] fieldsData = fields.split(",");
            InetAddress addr = InetAddress.getLocalHost();
            String ip = SysConfigProperties.useLocalPath ? "localhost" : addr.getHostAddress().toString();
            String realUrl = "http://" + ip + ":" + request.getLocalPort() + urlAddress;
            JSONArray jsonArray = ExcelUtils.sendHttp(request, response, realUrl, queryParams);
            String headTitle = title;
            Boolean showHeadTitle = true;
            TableHeaderMetaData headerMetaData = ExcelUtils.createTableHeader(headParents, map);
            if (expoptions != null) {
                JSONObject hws;
                if (expoptions.containsKey((Object)"headTitle")) {
                    headTitle = expoptions.getString("headTitle");
                }
                if (expoptions.containsKey((Object)"showHeadTitle")) {
                    showHeadTitle = expoptions.getBoolean("showHeadTitle");
                }
                if ((hws = expoptions.getJSONObject("colWidths")) != null) {
                    List<String> headers = Arrays.asList(fieldsData);
                    hws.forEach((key, value) -> {
                        if (headers.indexOf(key) != -1) {
                            headerMetaData.getColumns().get(headers.indexOf(key)).setWidth(Integer.parseInt(value.toString()));
                        }
                    });
                }
            }
            if (fieldcombos != null) {
                jsonArray.forEach(obj -> {
                    JSONObject jsonObject = (JSONObject)obj;
                    for (String key : fieldcombos.keySet()) {
                        if (!jsonObject.containsKey((Object)key)) continue;
                        JSONArray combos = fieldcombos.getJSONArray(key);
                        combos.forEach(combo -> {
                            JSONObject comboObject = (JSONObject)combo;
                            if (jsonObject.getString(key).equals(comboObject.getString("value"))) {
                                jsonObject.put(key, (Object)comboObject.getString("text"));
                            }
                        });
                    }
                });
            }
            TableData td = ExcelUtils.createTableData(jsonArray, headerMetaData, fieldsData);
            JsGridReportBase report = new JsGridReportBase(request, response);
            report.exportToExcel(title, "admin", td, showHeadTitle, headTitle);
        }
    }

    @RequestMapping(value={"/exportExcelMulti"})
    @ResponseBody
    public void exportExcelMulti(String bigTitle, String titles, String urlAddressArray, String headsArray, String fieldsArray, String queryParamsArray, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] urlAddressArrayData = urlAddressArray.split(",");
        ArrayList<TableData> tdList = new ArrayList<TableData>();
        for (int i = 0; i < urlAddressArrayData.length; ++i) {
            String heads = headsArray.split("]")[i];
            String fields = fieldsArray.split("]")[i];
            String queryParams = queryParamsArray.split("]")[i];
            if (StringUtils.isEmpty((Object)heads) || StringUtils.isEmpty((Object)fields)) continue;
            response.setContentType("application/msexcel;charset=GBK");
            String[] headsData = heads.split(",");
            String[] headParents = new String[headsData.length];
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (int n = 0; n < headsData.length; ++n) {
                String[] headParent = headsData[n].split(":");
                headParents[n] = headParent[0];
                if (headParent == null || headParent.length <= 1) continue;
                String[] headChild = headParent[1].split(";");
                map.put(headParent[0], headChild);
            }
            String[] fieldsData = fields.split(",");
            InetAddress addr = InetAddress.getLocalHost();
            String ip = SysConfigProperties.useLocalPath ? "localhost" : addr.getHostAddress().toString();
            String realUrl = "http://" + ip + ":" + request.getLocalPort() + urlAddressArrayData[i];
            JSONArray jsonArray = ExcelUtils.sendHttp(request, response, realUrl, queryParams);
            TableData td = ExcelUtils.createTableData(jsonArray, ExcelUtils.createTableHeader(headParents, map), fieldsData);
            tdList.add(td);
        }
        JsGridReportBase report = new JsGridReportBase(request, response);
        report.exportToExcelMulti(bigTitle, titles, "admin", tdList);
    }

    @RequestMapping(value={"/test"})
    public void test(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        entity.add(new ExcelExportEntity("\u59d3\u540d", (Object)"name"));
        entity.add(new ExcelExportEntity("\u6027\u522b", (Object)"sex"));
        ArrayList list = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            HashMap<String, String> datamap = new HashMap<String, String>();
            datamap.put("name", "1" + i);
            datamap.put("sex", "2" + i);
            list.add(datamap);
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u6d4b\u8bd5", "\u6d4b\u8bd5"), entity, list);
        String sFileName = "\u6587\u4ef6\u540d.xls";
        try {
            response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(sFileName, "UTF-8"))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        response.setHeader("Connection", "close");
        response.setHeader("Content-Type", "application/vnd.ms-excel");
        workbook.write((OutputStream)response.getOutputStream());
    }
}

