/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.exception.BusiException;
import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.exception.InvoiceDuplicatedException;
import com.guochuang.imp.base.common.interceptor.repeat.RepeatSubmitException;
import com.guochuang.imp.base.common.spring.entity.FieldComment;
import com.guochuang.imp.base.common.spring.entity.RequiredCheck;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.entity.BasLoginPageConfig;
import com.guochuang.imp.base.service.BasLoginPageConfigService;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class ExceptionController {
    private static final String DEFAULT_ERROR_MSG = "\u7cfb\u7edf\u5f00\u4e2a\u5c0f\u5dee\u4e86,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458";
    private static final String REQUESTBODY_ERROR_MSG = "\u8bf7\u6c42\u4f53\u7f3a\u5931\u6216\u683c\u5f0f\u4e0d\u6b63\u786e";
    private static Logger loger = LoggerFactory.getLogger(ExceptionController.class);
    @Autowired
    private BasLoginPageConfigService configService;

    @ExceptionHandler(value={BusiException.class})
    public Object BusiException(HttpServletRequest request, HttpServletResponse response, BusiException e) {
        loger.error(e.getMessage(), (Throwable)e);
        if (this.isAjax(request)) {
            this.ajaxRespons(request, response, e);
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/error").addObject("errorMsg", (Object)e.getMessage()));
    }

    @ExceptionHandler(value={GEPSBisException.class})
    public Object GEPSBisException(HttpServletRequest request, HttpServletResponse response, GEPSBisException e) {
        loger.error(e.getMessage(), (Throwable)e);
        if (this.isAjax(request)) {
            this.ajaxRespons(request, response, e);
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/error").addObject("errorMsg", (Object)e.getMessage()));
    }

    @ExceptionHandler(value={InvoiceDuplicatedException.class})
    public Object invoiceDuplicatedException(HttpServletRequest request, HttpServletResponse response, InvoiceDuplicatedException e) {
        loger.error(e.getMessage(), (Throwable)e);
        if (this.isAjax(request)) {
            this.ajaxRespons(request, response, e);
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/error").addObject("errorMsg", (Object)e.getMessage()));
    }

    @ExceptionHandler(value={ObjectOptimisticLockingFailureException.class})
    public Object ObjectOptimisticLockingFailureException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.logExceptionInfo(e, request);
        if (this.isAjax(request)) {
            this.ajaxRespons(request, response, e, "\u6570\u636e\u5df2\u7ecf\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/error").addObject("errorMsg", (Object)"\u6570\u636e\u5df2\u7ecf\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
    }

    @ExceptionHandler(value={RepeatSubmitException.class})
    public Object RepeatSubmitException(HttpServletRequest request, HttpServletResponse response, RepeatSubmitException e) {
        this.logExceptionInfo(e, request);
        if (this.isAjax(request)) {
            this.ajaxRespons(request, response, e, e.getMessage());
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/error").addObject("errorMsg", (Object)e.getMessage()));
    }

    @ExceptionHandler(value={Exception.class})
    public Object handlerException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.logExceptionInfo(e, request);
        e.getMessage();
        if (this.isAjax(request)) {
            String msg = DEFAULT_ERROR_MSG;
            if (e.getMessage() != null && e.getMessage().contains("\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25") && e.getCause() != null && e.getCause().getCause() != null) {
                msg = e.getCause().getCause().getMessage();
            }
            this.ajaxRespons(request, response, e, msg);
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/error").addObject("msg", (Object)new JsonMsg(DEFAULT_ERROR_MSG)));
    }

    @ExceptionHandler(value={FileStoreException.class})
    public Object FileStoreException(HttpServletRequest request, HttpServletResponse response, FileStoreException e) {
        this.logExceptionInfo(e, request);
        return this.addTechSupport(new ModelAndView("/errorpage/filenotfound").addObject("errorMsg", (Object)DEFAULT_ERROR_MSG));
    }

    public void ajaxRespons(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.ajaxRespons(request, response, e, null);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ModelAndView processUnauthenticatedException(HttpServletRequest request, HttpServletResponse response, UnauthorizedException e) {
        if (this.isAjax(request)) {
            this.ajaxRespons(request, response, (Exception)e, "\u60a8\u5f53\u524d\u6ca1\u6709\u8be5\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
            return null;
        }
        return this.addTechSupport(new ModelAndView("/errorpage/403").addObject("msg", (Object)new JsonMsg(DEFAULT_ERROR_MSG)));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<JsonMsg> handleMissingBody(HttpServletRequest request, HttpServletResponse response, HttpMessageNotReadableException e) {
        String msg = REQUESTBODY_ERROR_MSG;
        this.ajaxRespons(request, response, (Exception)e, msg + ":" + e.getMessage());
        return null;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseEntity<JsonMsg> handleValidationException(HttpServletRequest request, HttpServletResponse response, MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        LinkedHashMap errorDetails = new LinkedHashMap();
        LinkedHashMap errors = new LinkedHashMap();
        bindingResult.getFieldErrors().forEach(error -> {
            try {
                Field field = ReflectionUtils.findField(ex.getBindingResult().getTarget().getClass(), (String)error.getField());
                String comment = field != null && field.isAnnotationPresent(FieldComment.class) ? field.getAnnotation(FieldComment.class).name() : error.getField();
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("field", error.getField());
                String errorMsg = error.getDefaultMessage();
                if (field != null && field.isAnnotationPresent(RequiredCheck.class)) {
                    detail.put("errorCode", field.getAnnotation(RequiredCheck.class).errorCode());
                    String tempMsg = field.getAnnotation(RequiredCheck.class).message();
                    if (StringUtil.isNotEmpty(tempMsg)) {
                        errorMsg = tempMsg;
                    }
                }
                detail.put("message", String.format("%s(%s): %s", comment, field.getType().getSimpleName(), errorMsg));
                detail.put("rejectedValue", error.getRejectedValue());
                errors.put(error.getField(), StringUtil.null2String(detail.get("message")));
                errorDetails.put(error.getField(), detail);
            }
            catch (Exception e) {
                errorDetails.put(error.getField(), error.getDefaultMessage());
            }
        });
        JsonMsg msg = new JsonMsg(false, "\u53c2\u6570\u9519\u8bef", errorDetails);
        return ResponseEntity.badRequest().body((Object)msg);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public ResponseEntity<JsonMsg> handleConstraintViolation(HttpServletRequest request, HttpServletResponse response, ConstraintViolationException ex) {
        HashMap errors = new HashMap();
        ex.getConstraintViolations().forEach(violation -> {
            String field = violation.getPropertyPath().toString();
            errors.put(field, violation.getMessage());
        });
        JsonMsg msg = new JsonMsg(false, "\u53c2\u6570\u9519\u8bef", errors);
        return ResponseEntity.badRequest().body((Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ajaxRespons(HttpServletRequest request, HttpServletResponse response, Exception e, String msg) {
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = null;
        try {
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = e.getMessage();
            }
            out = response.getWriter();
            out.write(JSON.toJSONString((Object)new JsonMsg(false, msg)).toString());
            out.flush();
        }
        catch (IOException ex) {
            loger.error("ajax\u54cd\u5e94\u8f93\u51fa\u5f02\u5e38\u3002", (Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    loger.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", (Throwable)ex);
                }
            }
        }
    }

    private boolean isAjax(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null && "XMLHttpRequest".equals(request.getHeader("X-Requested-With").toString()) || "application/x-www-form-urlencoded".equals(request.getContentType()) || !StringUtils.isEmpty((CharSequence)request.getContentType()) && request.getContentType().contains("multipart/form-data");
    }

    private ModelAndView addTechSupport(ModelAndView model) {
        BasLoginPageConfig config = this.configService.getConfig();
        model.addObject("companyName", (Object)"\u79d1\u5927\u56fd\u521b\u8f6f\u4ef6\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        if (config != null && config.getTechnicalSupport() != null) {
            model.addObject("companyName", (Object)config.getTechnicalSupport());
        }
        return model;
    }

    private void logExceptionInfo(Exception e, HttpServletRequest request) {
        String errorUrl = request.getRequestURI();
        String method = request.getMethod();
        LoginUser loginuser = (LoginUser)request.getSession().getAttribute("LOGIN_USER");
        String userinfor = loginuser == null ? "" : loginuser.getOrgName() + "-" + loginuser.getDeptName() + "-" + loginuser.getAccountName() + "[accountid:" + loginuser.getAccountid() + "]";
        String errorParams = JSON.toJSONString((Object)request.getParameterMap());
        String errorMsg = "\u8bf7\u6c42:[URL:" + errorUrl + " method:" + method + "],\u53c2\u6570:[" + errorParams + "],\u7528\u6237\u4fe1\u606f:[" + userinfor + "]";
        loger.error(errorMsg, (Throwable)e);
    }

    public String getErrorsMsg(Map<String, String> errors, boolean onlyMsg) {
        if (errors == null || errors.isEmpty()) {
            return "";
        }
        if (onlyMsg) {
            return String.join((CharSequence)";", errors.values());
        }
        StringBuilder errorMsg = new StringBuilder();
        errors.entrySet().stream().forEach(entry -> {
            if (errorMsg.length() > 0) {
                errorMsg.append(";");
            }
            errorMsg.append("\u5b57\u6bb5" + (String)entry.getKey() + "\u4e0d\u5408\u6cd5\uff1a" + (String)entry.getValue());
        });
        return errorMsg.toString();
    }
}

