/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasMessageCollapse;
import com.guochuang.imp.base.service.BasMessageCollapseService;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basMessageCollapse"})
public class BasMessageCollapseController
extends BaseController {
    @Autowired
    private BasMessageCollapseService basMessageCollapseService;
    @Autowired
    private FlowUtilService flowUtilService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(String fuzzy, int page, int rows, String sort, String order) {
        return this.basMessageCollapseService.pageAll(fuzzy, page, rows, sort, order);
    }

    @PostMapping(value={"/saveBasMessageCollapse"})
    @ResponseBody
    public JsonMsg saveBasMessageCollapse(HttpServletRequest request, BasMessageCollapse entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.basMessageCollapseService.saveBasMessageCollapse(entity);
        return msg;
    }

    @PostMapping(value={"/findBasMessageCollapse"})
    @ResponseBody
    public BasMessageCollapse findBasMessageCollapse(Long id) {
        BasMessageCollapse entity = this.basMessageCollapseService.findBasMessageCollapse(id);
        return entity;
    }

    @PostMapping(value={"/delBasMessageCollapse"})
    @ResponseBody
    public JsonMsg delBasMessageCollapse(Long id) {
        this.basMessageCollapseService.delBasMessageCollapse(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/getFlowActByFlowCode"})
    @ResponseBody
    public List<?> getFlowActByFlowCode(HttpServletRequest request, String flowCode) {
        List<Map<String, Object>> list = this.flowUtilService.getFlowActList(flowCode);
        list.forEach(map -> {
            map.put("value", map.get("ACTIVITYDEFID"));
            map.put("text", map.get("ACTNAME"));
        });
        return list;
    }
}

