/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.filter.MenuConfirmFilter;
import com.guochuang.imp.base.common.util.CSSUtil;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasMenu;
import com.guochuang.imp.base.service.BasFormLinkService;
import com.guochuang.imp.base.service.BasMenuService;
import com.guochuang.imp.workflow.service.StfBusinessProcessService;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/BasMenu"})
public class BasMenuController
extends BaseController {
    @Autowired
    private BasFormLinkService basformlinkService;
    @Autowired
    private BasMenuService basmenuService;
    @Autowired
    private StfBusinessProcessService stfBusinessProcessService;

    @RequestMapping(value={"/pageBasMenu"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasMenu(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basmenuService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/treeBasMenuWithRoot"})
    @ResponseBody
    public Object treeBasMenuWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> deptlist = this.basmenuService.treeBasMenu(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u529f\u80fd\u83dc\u5355");
        root.setChecked(false);
        root.setChildren(deptlist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasMenuWithEnable"})
    @ResponseBody
    public Object treeBasMenuWithEnable(@RequestParam(value="pid", defaultValue="0") Long pid, Long detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        if (detailId != null) {
            ComBoxTreeNode node = new ComBoxTreeNode();
            BasMenu menInfo = this.basmenuService.findBasMenu(detailId);
            node.setId(menInfo.getMenuId().toString());
            node.setText(menInfo.getMenuName());
            list.add(node);
            return list;
        }
        List<ComBoxTreeNode> deptlist = this.basmenuService.treeBasMenuWithEnable(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u529f\u80fd\u83dc\u5355");
        root.setChecked(false);
        root.setChildren(deptlist);
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasMenu"})
    @ResponseBody
    public Object treeBasMenu(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            BasMenu menu = this.basmenuService.findBasMenu(Long.parseLong(detailId));
            if (menu != null) {
                root.setText(menu.getMenuName());
            }
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basmenuService.treeBasMenu(pid);
    }

    @RequestMapping(value={"/getAccountBasMenu"})
    @ResponseBody
    public Object getAccountBasMenu(HttpServletRequest request, @RequestParam(value="pid", defaultValue="0") Long pid) {
        return this.basmenuService.getAccountBasMenu(this.getLoginUser(request).getAccountid(), pid);
    }

    @RequestMapping(value={"/findBasMenu"})
    @ResponseBody
    public Object findBasMenu(Long id) {
        return this.basmenuService.findBasMenu(id);
    }

    @RequestMapping(value={"/findBasMenuByBusiness"})
    @ResponseBody
    public Object findBasMenuByBusiness(Long id) {
        JsonMsg msg = new JsonMsg();
        List<ComBoxTreeNode> list = this.basmenuService.treeBasMenu(id);
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u8bf7\u9009\u62e9\u6700\u5e95\u5c42\u83dc\u5355");
            return msg;
        }
        BasMenu entity = this.basmenuService.findBasMenu(id);
        if (entity != null) {
            msg.setSuccess(true);
            msg.setO(entity);
        } else {
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/saveBasMenu"})
    @ResponseBody
    public Object saveBasMenu(BasMenu entity) {
        JsonMsg msg = new JsonMsg();
        if (StringUtils.isEmpty((String)entity.getIsUse())) {
            entity.setIsUse("Y");
        }
        if (StringUtils.isEmpty((String)entity.getAppCode())) {
            entity.setIsUse("Y");
        }
        this.basmenuService.saveBasMenu(entity);
        MenuConfirmFilter.reloadMenus();
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasMenu"})
    @ResponseBody
    public Object delBasMenu(Long id) {
        this.basmenuService.delBasMenu(id);
        MenuConfirmFilter.reloadMenus();
        return new JsonMsg();
    }

    @RequestMapping(value={"/delBasMenuAndChild"})
    @ResponseBody
    public Object delBasMenuAndChild(Long id) {
        this.basmenuService.delBasMenuAndChild(id);
        MenuConfirmFilter.reloadMenus();
        return new JsonMsg();
    }

    @RequestMapping(value={"/hasrole"})
    @ResponseBody
    public Object hasrole(HttpServletRequest request, String menuurl) {
        JsonMsg msg = new JsonMsg();
        LoginUser loginuser = this.getLoginUser(request);
        msg.setSuccess(this.basmenuService.hasMenuRole(loginuser.getAccountid(), menuurl));
        return msg;
    }

    @RequestMapping(value={"/chooseIcons"})
    public ModelAndView chooseIcons(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        List<String> iconlist = CSSUtil.getNameList("classpath:/static/plugins/iconfont/iconfont.css", ":before");
        view.addObject("iconlist", iconlist);
        view.setViewName("/base/chooseIcons");
        return view;
    }

    @RequestMapping(value={"/chooseBtnIcons"})
    public ModelAndView chooseBtnIcons(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        List<String> iconlist = CSSUtil.getNameList("classpath:/static/style/icon.css", null);
        view.addObject("iconlist", iconlist);
        view.setViewName("/base/chooseIcons");
        return view;
    }

    @RequestMapping(value={"/sitemap"})
    public ModelAndView sitemap(HttpServletRequest request) {
        LoginUser loginuser = this.getLoginUser(request);
        ModelAndView view = new ModelAndView();
        view.addObject("menulist", this.basmenuService.getAccountBasMenuSiteMap(loginuser.getAccountid()));
        view.setViewName("/common/siteMap");
        return view;
    }

    @RequestMapping(value={"/sitemapNew"})
    public ModelAndView sitemapNew(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.setViewName("/common/siteMapNew");
        return view;
    }

    @RequestMapping(value={"/getSitemapData"})
    @ResponseBody
    public Object getSitemapData(HttpServletRequest request) {
        JsonMsg msg = new JsonMsg();
        LoginUser loginuser = this.getLoginUser(request);
        msg.setO(this.basmenuService.getAccountBasMenuSiteMap(loginuser.getAccountid()));
        msg.setSuccess(true);
        return msg;
    }

    @RequestMapping(value={"/personSetting"})
    public ModelAndView personSetting(HttpServletRequest request) {
        LoginUser loginuser = this.getLoginUser(request);
        ModelAndView view = new ModelAndView();
        view.addObject("menulist", this.basmenuService.getAccountBasMenuSiteMap(loginuser.getAccountid()));
        view.setViewName("/common/personSetting");
        return view;
    }

    @RequestMapping(value={"/formmap"})
    public ModelAndView formmap(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.addObject("PList", this.stfBusinessProcessService.getPList());
        view.addObject("fList", this.stfBusinessProcessService.commonlyUsedFlow());
        view.addObject("links", this.basformlinkService.myFormFlow());
        view.setViewName("/workflow/flow");
        return view;
    }

    @RequestMapping(value={"/getFLowComb"})
    @ResponseBody
    public Object getFLowComb(HttpServletRequest request) {
        return this.getFlowList(request);
    }

    private List<Map<String, Object>> getFlowList(HttpServletRequest request) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.addAll(this.basmenuService.getAccountFormMap(""));
        return list;
    }

    @RequestMapping(value={"/selectProject"})
    @ResponseBody
    public void selectProject(HttpServletRequest request, Long projectId) {
    }

    @RequestMapping(value={"/getAccountFirstMenu"})
    @ResponseBody
    public Object getAccountFirstMenu(HttpServletRequest request, @RequestParam(value="pid", defaultValue="0") Long pid) {
        return this.basmenuService.getAccountFirstMenu(pid);
    }

    @RequestMapping(value={"/checkRegularPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public Object checkPasswordTwice(HttpServletRequest request, String regularPassword, Long mId) throws ParseException, SQLException {
        JsonMsg msg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        BasMenu menu = this.basmenuService.findBasMenu(mId);
        if (menu.getRegularPassword().equals(regularPassword)) {
            msg.setSuccess(true);
            msg.setMsg("\u5bc6\u7801\u6821\u9a8c\u6210\u529f");
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u5bc6\u7801\u6821\u9a8c\u5931\u8d25");
        }
        return msg;
    }
}

