/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasFlowActPrint;
import com.guochuang.imp.base.entity.BasFlowActPrintDetail;
import com.guochuang.imp.base.service.BasFlowActPrintService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.htmlunit.jetty.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basFlowActPrint"})
public class BasFlowActPrintController
extends BaseController {
    @Autowired
    private BasFlowActPrintService basFlowActPrintService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(String search, int page, int rows, String sort, String order) {
        return this.basFlowActPrintService.pageAll(search, page, rows, sort, order);
    }

    @PostMapping(value={"/saveBasFlowActPrint"})
    @ResponseBody
    public JsonMsg saveBasFlowActPrint(HttpServletRequest request, BasFlowActPrint entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        String detailList = request.getParameter("detailList");
        if (entity.getPrintId() == null && this.basFlowActPrintService.findByProcessdefidAndIsUse(entity.getProcessdefid())) {
            msg.setSuccess(false);
            msg.setMsg("\u8be5\u6d41\u7a0b\u7248\u672c\u5df2\u914d\u7f6e");
            return msg;
        }
        if (StringUtil.isNotBlank((String)detailList) && !"[]".equals(detailList)) {
            List list = JSON.parseArray((String)detailList, BasFlowActPrintDetail.class);
            List list1 = list.stream().filter(e -> !StringUtil.isEmpty((String)e.getActCode())).map(BasFlowActPrintDetail::getActCode).collect(Collectors.toList());
            HashSet set = new HashSet(list1);
            if (list1.size() > set.size()) {
                msg.setSuccess(false);
                msg.setMsg("\u8282\u70b9\u8c03\u7528\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5");
                return msg;
            }
        }
        this.basFlowActPrintService.saveBasFlowActPrint(entity, detailList);
        return msg;
    }

    @PostMapping(value={"/findBasFlowActPrint"})
    @ResponseBody
    public BasFlowActPrint findBasFlowActPrint(Long id) {
        BasFlowActPrint entity = this.basFlowActPrintService.findBasFlowActPrint(id);
        return entity;
    }

    @PostMapping(value={"/delBasFlowActPrint"})
    @ResponseBody
    public JsonMsg delBasFlowActPrint(Long id) {
        this.basFlowActPrintService.delBasFlowActPrint(id);
        return new JsonMsg();
    }

    @PostMapping(value={"/findActListByFlowName"})
    @ResponseBody
    public List<Map<String, Object>> findActListByFlowName(String processdefid) {
        return this.basFlowActPrintService.findActListByFlowName(processdefid);
    }

    @RequestMapping(value={"/loadFlowInfo"})
    @ResponseBody
    public JsonMsg loadFlowInfo(Long processinstid) {
        this.basFlowActPrintService.loadFlowInfo(processinstid);
        return new JsonMsg();
    }
}

