/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasEmpLoginStatistics;
import com.guochuang.imp.base.service.BasEmpLoginStatisticsService;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basEmpLoginStatistics"})
public class BasEmpLoginStatisticsController
extends BaseController {
    @Autowired
    private BasEmpLoginStatisticsService basEmpLoginStatisticsService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(@RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String startDate, String endDate, String sort, String order) {
        return this.basEmpLoginStatisticsService.pageAll(page, rows, startDate, endDate, sort, order);
    }

    @PostMapping(value={"/saveBasEmpLoginStatistics"})
    @ResponseBody
    public JsonMsg saveBasEmpLoginStatistics(HttpServletRequest request, BasEmpLoginStatistics entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getStatisticsId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.basEmpLoginStatisticsService.saveBasEmpLoginStatistics(entity);
        return msg;
    }

    @PostMapping(value={"/findBasEmpLoginStatistics"})
    @ResponseBody
    public PageObject findBasEmpLoginStatistics(@RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, Long id, String keyword, String deptId) {
        return this.basEmpLoginStatisticsService.findBasEmpLoginStatistics(page, rows, id, keyword, deptId);
    }

    @PostMapping(value={"/delBasEmpLoginStatistics"})
    @ResponseBody
    public JsonMsg delBasEmpLoginStatistics(Long id) {
        this.basEmpLoginStatisticsService.delBasEmpLoginStatistics(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/reportMonthlyStatistics"})
    public String reportMonthlyStatistics(Model model) {
        Map<String, Object> monthlyStatistics = this.basEmpLoginStatisticsService.getMonthlyStatistics();
        model.addAttribute("monthlyStatistics", monthlyStatistics);
        return "/report/reportMonthlyStatistics";
    }

    @RequestMapping(value={"/getTop10"})
    @ResponseBody
    public Object getTop10() {
        return this.basEmpLoginStatisticsService.getTop10();
    }

    @RequestMapping(value={"/getOrgProportion"})
    @ResponseBody
    public Object getOrgProportion() {
        return this.basEmpLoginStatisticsService.getOrgProportion();
    }
}

