/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.spring.SystemControllerLog;
import com.guochuang.imp.base.common.util.AesUtil;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.Md5Utils;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasDept;
import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.BasSignaturePersonal;
import com.guochuang.imp.base.entity.BasSysOptlog;
import com.guochuang.imp.base.entity.ImUser;
import com.guochuang.imp.base.service.BasDeptService;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasEmpService;
import com.guochuang.imp.base.service.BasOrgService;
import com.guochuang.imp.base.service.BasSignaturePersonalService;
import com.guochuang.imp.base.service.BasSysOptlogService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.pub.entity.PubContactOrg;
import com.guochuang.imp.pub.service.PubContactOrgService;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/basemp"})
public class BasEmpController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(BasEmpController.class);
    @Autowired
    private BasSysOptlogService optlogService;
    @Autowired
    private BasEmpService basEmpService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private BasSignaturePersonalService bassignaturepersonalService;
    @Autowired
    private PubContactOrgService pubContactOrgService;

    @RequestMapping(value={"/pageall"})
    @ResponseBody
    public Object quertAllEmp(Long orgid, Long deptid, String search, Integer page, Integer rows) {
        if (orgid == null) {
            return new PageObject();
        }
        return (PageObject)this.basEmpService.pageall(orgid, deptid, search, page, rows);
    }

    @RequestMapping(value={"/queryByName"})
    @ResponseBody
    public Object quertAllEmp(Long orgId, Long deptId, String empName, String showCancel) {
        return this.basEmpService.queryByName(orgId, deptId, empName, showCancel);
    }

    @RequestMapping(value={"/getAllWebChatUser"})
    @ResponseBody
    public List<ImUser> getAllWebChatUser() {
        return this.basEmpService.queryAllWebChatUser();
    }

    @RequestMapping(value={"/queryPasswordByCureentUser"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryPasswordByCureentUser(HttpServletRequest request) {
        String idm = Objects.toString(request.getSession().getAttribute("idm"), "");
        if ("1".equals(idm)) {
            return false;
        }
        BasEmp basEmp = this.getLoginUser(request).getEmp();
        boolean flag = CommonService.initPassword;
        Object isvalidpassword = request.getSession().getAttribute("IS_VALID_PSW");
        boolean validpassword = true;
        validpassword = isvalidpassword != null ? Boolean.parseBoolean(isvalidpassword.toString()) : true;
        flag = flag && (SysUtils.md5two("123").equals(basEmp.getLoginPassword()) || !validpassword);
        request.setAttribute("initPassword", (Object)flag);
        return flag;
    }

    @RequestMapping(value={"/changeInitPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public Object changeInitPassword(HttpServletRequest request, String newpassword1, String newpassword2) {
        JsonMsg msg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        if (user != null) {
            BasEmp basEmp = this.basEmpService.findEmpByempId(user.getEmpid());
            basEmp.setLoginPassword(Md5Utils.generate(newpassword1));
            basEmp.setPwUpdateTime(new Date());
            this.basEmpService.saveEmp(basEmp);
            this.basEmpService.changeOaPassword(basEmp.getEmpCode(), newpassword1);
            BasEmp emp = user.getEmp();
            emp.setLoginPassword(Md5Utils.md5HexTwo(newpassword1));
            user.setEmp(emp);
            if (msg.isSuccess()) {
                msg.setMsg("\u5bc6\u7801\u4fee\u6539\u6210\u529f,\u8bf7\u7528\u65b0\u5bc6\u7801\u91cd\u65b0\u767b\u5f55");
            }
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u5bc6\u7801\u5df2\u7ecf\u4fee\u6539");
            return msg;
        }
        request.getSession().setAttribute("LOGIN_USER", (Object)user);
        request.getSession().setAttribute("IS_VALID_PSW", (Object)true);
        return msg;
    }

    @RequestMapping(value={"/saveemp"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveEmp(BasEmp basEmp) throws RemoteException {
        if (!this.basEmpService.hasloginName(basEmp.getLoginName(), basEmp.getEmpId())) {
            return new JsonMsg(false, "\u767b\u9646\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u5c1d\u8bd5\u5176\u4ed6\u767b\u9646\u540d");
        }
        JsonMsg msg = new JsonMsg();
        Boolean isAdd = basEmp.getEmpId() == null;
        if (isAdd.booleanValue()) {
            basEmp.setLoginPassword(SysUtils.md5two("123"));
            basEmp.setStatus("02");
            basEmp.setIsUse("Y");
            this.basEmpService.saveEmp(basEmp);
            BasEmpAccount basEmpAccount = new BasEmpAccount();
            basEmpAccount.setAccountName(basEmp.getEmpName());
            basEmpAccount.setEmpId(basEmp.getEmpId());
            basEmpAccount.setIsUse("Y");
            basEmpAccount.setOrgId(basEmp.getOrgId());
            basEmpAccount.setDeptId(basEmp.getDeptId());
            basEmpAccount = this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
        } else {
            BasEmp oldemp = this.basEmpService.findEmpByempId(basEmp.getEmpId());
            oldemp.setEmpName(basEmp.getEmpName());
            oldemp.setLoginName(basEmp.getLoginName());
            oldemp.setDisplayNo(basEmp.getDisplayNo());
            oldemp.setDeptId(basEmp.getDeptId());
            oldemp.setIsUse("Y");
            oldemp.setIsVisual(basEmp.getIsVisual());
            oldemp.setOrgId(basEmp.getOrgId());
            oldemp.setStatus(basEmp.getStatus());
            oldemp.setContactOrgId(basEmp.getContactOrgId());
            oldemp.setEmpCode(basEmp.getEmpCode());
            oldemp.setHrEmpId(basEmp.getHrEmpId());
            this.basEmpService.saveEmp(oldemp);
            List<BasEmpAccount> basEmpAccounts = this.basEmpAccountService.findByEmpId(oldemp.getEmpId());
            if (basEmpAccounts != null && basEmpAccounts.size() > 0) {
                for (BasEmpAccount basEmpAccount : basEmpAccounts) {
                    if (basEmpAccount.getOrgId() == null) {
                        basEmpAccount.setOrgId(oldemp.getOrgId());
                    }
                    if (basEmpAccount.getDeptId() == null) {
                        basEmpAccount.setDeptId(oldemp.getDeptId());
                    }
                    this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
                }
                if (basEmpAccounts.size() == 1) {
                    basEmpAccounts.get(0).setOrgId(oldemp.getOrgId());
                    basEmpAccounts.get(0).setDeptId(oldemp.getDeptId());
                    this.basEmpAccountService.saveBasEmpAccount(basEmpAccounts.get(0));
                }
            }
        }
        return msg;
    }

    @RequestMapping(value={"/delemp"}, method={RequestMethod.POST})
    @ResponseBody
    public Object delEmp(String empId) throws RemoteException {
        JsonMsg msg = new JsonMsg();
        BasEmp entity = this.basEmpService.findEmpByempId(Long.parseLong(empId));
        this.basEmpService.delEmp(empId);
        return msg;
    }

    @RequestMapping(value={"/cancelemp"}, method={RequestMethod.POST})
    @ResponseBody
    public Object cancelEmp(String empId) throws RemoteException {
        JsonMsg msg = new JsonMsg();
        this.basEmpService.cancelEmp(empId);
        return msg;
    }

    @RequestMapping(value={"/basempdetail"})
    public ModelAndView basEmpDetail(Long id) throws RemoteException {
        Object o = this.basEmpService.findDBOne(id);
        List list = this.basEmpAccountService.findBDAccountList(id);
        ModelAndView view = new ModelAndView();
        view.setViewName("/base/basempdetail");
        view.addObject("emp", o);
        view.addObject("accountlist", (Object)list);
        return view;
    }

    @RequestMapping(value={"/queryEmpById"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryEmpById(String empId) {
        PubContactOrg org;
        BasDept dept;
        BasEmp entity = this.basEmpService.findEmpByempId(Long.parseLong(empId));
        if (entity.getOrgId() != null) {
            entity.setOrgId_TEXT_(this.basOrgService.findByOrgId(entity.getOrgId()).getOrgName());
        }
        if (entity.getDeptId() != null && (dept = this.basDeptService.findByDeptId(entity.getDeptId())) != null) {
            entity.setDeptId_TEXT_(this.basDeptService.findByDeptId(entity.getDeptId()).getDeptName());
        }
        if (entity.getContactOrgId() != null && (org = this.pubContactOrgService.findPubContactOrg(entity.getContactOrgId())) != null) {
            entity.setContactOrgId_TEXT_(org.getContactOrgName());
        }
        return entity;
    }

    @RequestMapping(value={"/queryCurrentEmpInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryEmpInfo(HttpServletRequest request) {
        LoginUser user = this.getLoginUser(request);
        BasEmp emp = this.basEmpService.findEmpByempId(user.getEmpid());
        BasEmpAccount account = this.basEmpAccountService.findById(user.getAccountid());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("emp", emp);
        map.put("account", account);
        return map;
    }

    @RequestMapping(value={"/findEmpById"}, method={RequestMethod.POST})
    @ResponseBody
    public Object findEmpById(Long id) {
        return this.basEmpService.findEmpByempId(id);
    }

    @RequestMapping(value={"/queryAllEmplist"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryAllEmplist() {
        return this.basEmpService.queryAllEmplist();
    }

    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public Object resetPassword(String empId) {
        JsonMsg msg = new JsonMsg();
        BasEmp basEmp = this.basEmpService.findEmpByempId(Long.parseLong(empId));
        basEmp.setLoginPassword(SysUtils.md5two("123"));
        this.basEmpService.changeOaPassword(basEmp.getEmpCode(), "123");
        this.basEmpService.saveEmp(basEmp);
        msg.setSuccess(true);
        msg.setMsg("\u5bc6\u7801\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u5bc6\u7801:123");
        return msg;
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.POST})
    @ResponseBody
    public Object unlock(long empId) {
        JsonMsg msg = new JsonMsg();
        BasEmp basEmp = this.basEmpService.findEmpByempId(empId);
        basEmp.setLockCount(0L);
        basEmp.setLockTime(null);
        this.basEmpService.saveEmp(basEmp);
        msg.setSuccess(true);
        msg.setMsg("\u89e3\u9501\u6210\u529f,\u8be5\u7528\u6237\u73b0\u5728\u53ef\u4ee5\u6b63\u5e38\u767b\u9646");
        return msg;
    }

    @RequestMapping(value={"/saveSign"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveSign(HttpServletRequest request, String sign) {
        LoginUser user = this.getLoginUser(request);
        BasEmpAccount account = this.basEmpAccountService.findById(user.getAccountid());
        if (StringUtils.isNotEmpty((String)account.getSign())) {
            BasSignaturePersonal entity = new BasSignaturePersonal();
            if (!account.getSign().equals(sign)) {
                entity.setSign(sign);
                entity.setAccountId(this.getLoginUser(request).getAccountid());
                entity.setStartDate(new Date());
                entity.setModifyAccount(this.getLoginUser(request).getAccountid());
                entity.setModifyTime(new Date());
                entity.setIsUse("Y");
                if (entity.getSignaturePersonalId() == null) {
                    entity.setCreateAccount(this.getLoginUser(request).getAccountid());
                    entity.setCreateTime(new Date());
                }
                this.bassignaturepersonalService.saveBasSignaturePersonal(entity);
                BasSignaturePersonal d = this.bassignaturepersonalService.findByAccountIdAndEndIsNull(this.getLoginUser(request).getAccountid());
                d.setEndDate(new Date());
                this.bassignaturepersonalService.saveBasSignaturePersonal(d);
            }
        } else {
            BasSignaturePersonal entity = new BasSignaturePersonal();
            entity.setSign(sign);
            entity.setAccountId(this.getLoginUser(request).getAccountid());
            entity.setStartDate(new Date());
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            if (entity.getSignaturePersonalId() == null) {
                entity.setCreateAccount(this.getLoginUser(request).getAccountid());
                entity.setCreateTime(new Date());
            }
            this.bassignaturepersonalService.saveBasSignaturePersonal(entity);
        }
        account.setSign(sign);
        this.basEmpAccountService.saveBasEmpAccount(account);
        return new JsonMsg(true, "\u7b7e\u540d\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/loadSign"})
    @ResponseBody
    public Object loadSign(HttpServletRequest request, HttpServletResponse response) {
        LoginUser user = this.getLoginUser(request);
        BasEmpAccount account = this.basEmpAccountService.findById(user.getAccountid());
        BasSignaturePersonal b = this.bassignaturepersonalService.findByAccountIdAndDate(account.getAccountId(), new Date());
        if (b != null) {
            account.setSign(b.getSign());
        }
        return account;
    }

    @RequestMapping(value={"/changePassword"}, method={RequestMethod.POST})
    @ResponseBody
    @SystemControllerLog(description="\u7528\u6237\u5bc6\u7801\u4fee\u6539")
    public Object changePassword(HttpServletRequest request, String oldpassword, String newpassword1, String newpassword2, String empName, String telephone, String mobilephone, String email, String sex, String identification, String birthday, String ncUsercode, String ncPassword, String oaUsercode, String oaPassword, Long fontSize, String menuStyle, String themes, String sign) throws ParseException, SQLException {
        JsonMsg msg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        BasEmp basEmp = this.basEmpService.findEmpByempId(user.getEmpid());
        user.getEmp().setLoginPassword(basEmp.getLoginPassword());
        if (StringUtils.isEmpty((String)oldpassword) && StringUtils.isEmpty((String)newpassword1) && StringUtils.isEmpty((String)newpassword2)) {
            basEmp.setLoginPassword(user.getEmp().getLoginPassword());
        } else if (Md5Utils.verify(oldpassword, user.getEmp().getLoginPassword())) {
            if (StringUtils.isEmpty((String)newpassword1)) {
                msg.setSuccess(false);
                msg.setMsg("\u8bf7\u8f93\u5165\u65b0\u5bc6\u7801");
                return msg;
            }
            if (StringUtils.isEmpty((String)newpassword2)) {
                msg.setSuccess(false);
                msg.setMsg("\u8bf7\u8f93\u5165\u91cd\u590d\u5bc6\u7801");
                return msg;
            }
            basEmp.setLoginPassword(Md5Utils.generate(newpassword1));
            this.basEmpService.changeOaPassword(basEmp.getEmpCode(), newpassword1);
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
            return msg;
        }
        user.setFontSize(fontSize);
        user.setMenuStyle(menuStyle);
        if (!StringUtils.isEmpty((String)themes)) {
            user.setThemes(themes);
        }
        user.setSign(sign);
        request.getSession().setAttribute("LOGIN_USER", (Object)user);
        if (!StringUtils.isEmpty((String)empName)) {
            basEmp.setEmpName(empName);
        }
        basEmp.setPwUpdateTime(new Date());
        this.basEmpService.saveEmp(basEmp);
        BasEmpAccount account = this.basEmpAccountService.findById(user.getAccountid());
        account.setFontSize(fontSize);
        account.setMenuStyle(menuStyle);
        account.setThemes(themes);
        account.setSign(sign);
        this.basEmpAccountService.saveBasEmpAccount(account);
        msg.setSuccess(true);
        msg.setO(account);
        if (!StringUtils.isEmpty((String)newpassword1) && !StringUtils.isEmpty((String)newpassword2)) {
            msg.setMsg("\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        } else {
            msg.setMsg("\u7528\u6237\u4fe1\u606f\u4fee\u6539\u6210\u529f,\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        return msg;
    }

    @RequestMapping(value={"/changeTheme"}, method={RequestMethod.POST})
    @ResponseBody
    public Object changeTheme(HttpServletRequest request, String theme) {
        String menuStyle = request.getParameter("menuStyle");
        String menuDisplay = request.getParameter("menuDisplay");
        LoginUser user = this.getLoginUser(request);
        BasEmpAccount account = this.basEmpAccountService.findById(user.getAccountid());
        if (StringUtils.isNotBlank((String)theme)) {
            user.setThemes(theme);
            account.setThemes(theme);
        }
        if (StringUtils.isNotBlank((String)menuDisplay)) {
            user.setMenuDisplay(menuDisplay);
            account.setMenuDisplay(menuDisplay);
        }
        if (StringUtils.isNotBlank((String)menuStyle)) {
            user.setMenuStyle(menuStyle);
            account.setMenuStyle(menuStyle);
        }
        this.basEmpAccountService.saveBasEmpAccount(account);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/queryEmpIdByUser"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryEmpIdByUser(HttpServletRequest request) {
        LoginUser user = this.getLoginUser(request);
        return this.basEmpService.findEmpByempId(user.getEmpid());
    }

    @RequestMapping(value={"/bindCa"}, method={RequestMethod.POST})
    @ResponseBody
    public Object bindCa(HttpServletRequest request, Long empId, String strCert, String strSignData) {
        JsonMsg msg = new JsonMsg();
        return msg;
    }

    @RequestMapping(value={"/genEmpXml"})
    @ResponseBody
    public Object genEmpXml(Long empId) {
        return this.basEmpService.genEmpXml(empId);
    }

    @RequestMapping(value={"/pageSMSEmp"})
    @ResponseBody
    public Object pageSMSEmp(Long orgid, Long deptid, String search, Integer page, Integer rows) {
        return (PageObject)this.basEmpService.pageSMSEmp(orgid, deptid, search, page, rows);
    }

    @RequestMapping(value={"/setApp"}, method={RequestMethod.POST})
    @ResponseBody
    public Object setApp(Long empId, String isApp) throws RemoteException {
        JsonMsg msg = new JsonMsg();
        if (empId == null) {
            msg.setSuccess(false);
            msg.setMsg("\u8bf7\u5148\u9009\u62e9\u7528\u6237");
            return msg;
        }
        BasEmp entity = this.basEmpService.findEmpByempId(empId);
        entity.setIsApp(isApp);
        this.basEmpService.saveEmp(entity);
        if ("Y".equals(isApp)) {
            msg.setMsg("\u5df2\u8bbe\u7f6e" + entity.getEmpName() + "\u624b\u673a\u7aef\u6743\u9650");
        } else {
            msg.setMsg("\u5df2\u53d6\u6d88" + entity.getEmpName() + "\u624b\u673a\u7aef\u6743\u9650");
        }
        return msg;
    }

    @RequestMapping(value={"/resetIMEI"}, method={RequestMethod.POST})
    @ResponseBody
    public Object resetIMEI(Long empId, String IMEI) {
        JsonMsg msg = new JsonMsg();
        if (empId == null) {
            msg.setSuccess(false);
            msg.setMsg("\u8bf7\u5148\u9009\u62e9\u7528\u6237");
            return msg;
        }
        BasEmp entity = this.basEmpService.findEmpByempId(empId);
        entity.setImei(IMEI);
        entity.setDeviceMode(null);
        this.basEmpService.saveEmp(entity);
        return msg;
    }

    @RequestMapping(value={"/pageInnerEmp"})
    @ResponseBody
    public PageObject pageAllEmp(@RequestParam(value="search", defaultValue="") String search, Long orgId, Long deptId, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, @RequestParam(value="sort", defaultValue="") String sort, String order) {
        orgId = SysContent.GROUP_ORG.equals(orgId) ? null : orgId;
        return this.basEmpService.pageInnerEmp(search, orgId, deptId, page, rows, sort, order);
    }

    @RequestMapping(value={"/changePasswordTwice"}, method={RequestMethod.POST})
    @ResponseBody
    @SystemControllerLog(description="\u7528\u6237\u4e8c\u6b21\u5bc6\u7801\u4fee\u6539")
    public Object changePasswordTwice(HttpServletRequest request, String oldpassword, String newTwicePassword1, String newTwicePassword2) throws ParseException, SQLException {
        JsonMsg msg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        BasEmp basEmp = this.basEmpService.findEmpByempId(user.getEmpid());
        if (Md5Utils.verify(oldpassword, user.getEmp().getLoginPassword())) {
            if (StringUtils.isEmpty((String)newTwicePassword1)) {
                msg.setSuccess(false);
                msg.setMsg("\u8bf7\u8f93\u5165 \u65b0\u8bbe\u4e8c\u6b21\u5bc6\u7801");
                return msg;
            }
            if (StringUtils.isEmpty((String)newTwicePassword2)) {
                msg.setSuccess(false);
                msg.setMsg("\u8bf7\u8f93\u5165 \u91cd\u590d\u4e8c\u6b21\u5bc6\u7801");
                return msg;
            }
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
            return msg;
        }
        basEmp.setLoginPasswordTwice(SysUtils.md5two(newTwicePassword1));
        this.basEmpService.saveEmp(basEmp);
        user.setEmp(basEmp);
        request.getSession().setAttribute("LOGIN_USER", (Object)user);
        msg.setSuccess(true);
        msg.setO(basEmp);
        if (!StringUtils.isEmpty((String)newTwicePassword1) && !StringUtils.isEmpty((String)newTwicePassword2)) {
            msg.setMsg("\u4e8c\u6b21\u5bc6\u7801 \u8bbe\u7f6e\u6210\u529f");
        }
        return msg;
    }

    @RequestMapping(value={"/checkPasswordTwice"}, method={RequestMethod.POST})
    @ResponseBody
    public Object checkPasswordTwice(HttpServletRequest request, String twicePassword) throws ParseException, SQLException {
        JsonMsg msg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        BasEmp basEmp = this.basEmpService.findEmpByempId(user.getEmpid());
        if (basEmp.getLoginPasswordTwice().equals(SysUtils.md5two(twicePassword))) {
            msg.setSuccess(true);
            msg.setMsg("\u4e8c\u6b21\u5bc6\u7801\u6821\u9a8c\u6210\u529f");
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u4e8c\u6b21\u5bc6\u7801\u6821\u9a8c\u5931\u8d25");
        }
        return msg;
    }

    @RequestMapping(value={"/changeTransactionPwd"}, method={RequestMethod.POST})
    @ResponseBody
    @SystemControllerLog(description="\u7528\u6237\u4ea4\u6613\u5bc6\u7801\u4fee\u6539")
    public JsonMsg changeTransactionPwd(HttpServletRequest request, String oldPassword, String newPassword) {
        JsonMsg jsonMsg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        BasEmp basEmp = this.basEmpService.findEmpByempId(user.getEmpid());
        String tradePassWord = basEmp.getTradePassWord();
        if (!StringUtils.isNotEmpty((String)tradePassWord)) {
            tradePassWord = SysUtils.md5two("000000");
        }
        if (Md5Utils.verify(newPassword, tradePassWord)) {
            jsonMsg.setSuccess(false);
            jsonMsg.setMsg("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u91cd\u590d\uff01");
            return jsonMsg;
        }
        if (Md5Utils.verify(oldPassword, tradePassWord)) {
            basEmp.setTradePassWord(SysUtils.md5two(newPassword));
            this.basEmpService.saveEmp(basEmp);
            jsonMsg.setSuccess(true);
            jsonMsg.setMsg("\u4ea4\u6613\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff01");
        } else {
            jsonMsg.setSuccess(false);
            jsonMsg.setMsg("\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return jsonMsg;
    }

    @RequiresPermissions(value={"BasEmp:changePassword"})
    @RequestMapping(value={"/adminChangePassword"}, method={RequestMethod.POST})
    @ResponseBody
    public Object adminChangePassword(String empId, String loginPassword) {
        JsonMsg msg = new JsonMsg();
        BasEmp basEmp = this.basEmpService.findEmpByempId(Long.parseLong(empId));
        basEmp.setLoginPassword(SysUtils.md5two(loginPassword));
        this.basEmpService.saveEmp(basEmp);
        msg.setSuccess(true);
        return msg;
    }

    @RequestMapping(value={"/oaPassChange"}, method={RequestMethod.POST})
    @ResponseBody
    public Object oaPassChange(HttpServletRequest request, String empNo, String oldPassword, String newPassword, String forceUpdate) {
        JsonMsg msg = new JsonMsg();
        BasEmp basEmp = this.basEmpService.findByEmpCode(empNo);
        try {
            BasSysOptlog optlog = new BasSysOptlog();
            if (basEmp != null) {
                optlog.setOperateAccount(basEmp.getEmpName());
            }
            optlog.setOperateIp(SysUtils.getIpAddr(request));
            optlog.setOperateMethod("basEmp.oaPassChange");
            optlog.setOperateName("oa\u7528\u6237\u5bc6\u7801\u4fee\u6539\u540c\u6b65");
            optlog.setOperateTime(new Date());
            optlog.setOperateResult("N");
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)request.getParameterMap()));
            optlog.setOperateDetail("\u5730\u5740:" + request.getRequestURI() + "\n \u53c2\u6570:" + JSON.toJSONString((Object)json));
            this.optlogService.saveBasSysOptlog(optlog);
        }
        catch (Exception ex) {
            logger.error("==\u5f02\u5e38\u901a\u77e5\u5f02\u5e38==");
            logger.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)ex.getMessage());
        }
        if (basEmp == null) {
            return new JsonMsg(false, "\u627e\u4e0d\u5230\u5bf9\u5e94\u5e10\u53f7");
        }
        if (!(!StringUtils.isEmpty((String)oldPassword) && !StringUtils.isEmpty((String)newPassword) || "Y".equals(forceUpdate) && StringUtils.isEmpty((String)oldPassword))) {
            return new JsonMsg(false, "\u65e7\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (!StringUtils.isBlank((String)oldPassword)) {
                oldPassword = AesUtil.aesDecrypt(oldPassword, "2zo4GcdHYwZhImIX");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JsonMsg(false, "\u65e7\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        try {
            newPassword = AesUtil.aesDecrypt(newPassword, "2zo4GcdHYwZhImIX");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JsonMsg(false, "\u65b0\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        if ("Y".equals(forceUpdate)) {
            basEmp.setLoginPassword(SysUtils.md5two(newPassword));
        } else if (basEmp.getLoginPassword().equals(SysUtils.md5two(oldPassword))) {
            basEmp.setLoginPassword(SysUtils.md5two(newPassword));
        } else {
            return new JsonMsg(false, "\u65e7\u5bc6\u7801\u548c\u539f\u5bc6\u7801\u4e0d\u76f8\u540c");
        }
        this.basEmpService.saveEmp(basEmp);
        msg.setSuccess(true);
        msg.setMsg("\u5bc6\u7801\u66f4\u65b0\u6210\u529f");
        return msg;
    }
}

