/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasEarlyWarningSetting;
import com.guochuang.imp.base.entity.BasEarlyWarningUse;
import com.guochuang.imp.base.entity.BasModelManage;
import com.guochuang.imp.base.service.BasEarlyWarningLevelService;
import com.guochuang.imp.base.service.BasEarlyWarningSettingService;
import com.guochuang.imp.base.service.BasModelManageService;
import com.guochuang.imp.util.ReflectUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriUtils;

@Controller
@RequestMapping(value={"/basEarlyWarningSetting"})
public class BasEarlyWarningSettingController
extends BaseController {
    @Autowired
    private BasEarlyWarningSettingService basEarlyWarningSettingService;
    @Autowired
    private BasModelManageService basModelManageService;
    @Autowired
    private BasEarlyWarningLevelService basEarlyWarningLevelService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public Object pageAll(String search, Long warningType, int page, int rows, String sort, String order) {
        return this.basEarlyWarningSettingService.pageAll(search, warningType, page, rows, sort, order);
    }

    @PostMapping(value={"/saveBasEarlyWarningSetting"})
    @ResponseBody
    public JsonMsg saveBasEarlyWarningSetting(HttpServletRequest request, BasEarlyWarningSetting entity, String data) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        List list = null;
        if (data != null && !"".equals(data.trim())) {
            list = JSON.parseArray((String)data, BasEarlyWarningUse.class);
        }
        this.basEarlyWarningSettingService.saveBasEarlyWarningSetting(entity, list);
        return msg;
    }

    @PostMapping(value={"/findBasEarlyWarningSetting"})
    @ResponseBody
    public Object findBasEarlyWarningSetting(Long id) {
        Map<Object, Object> result = new HashMap();
        if (id != null) {
            BasEarlyWarningSetting entity = this.basEarlyWarningSettingService.findBasEarlyWarningSetting(id);
            result = ReflectUtil.beanToMap(entity);
            if (entity.getBusinessType() != null) {
                BasModelManage basModelManage = this.basModelManageService.findBasModelManage(entity.getBusinessType());
                result.put("businessTypeName", basModelManage.getModelName());
            }
        }
        return result;
    }

    @PostMapping(value={"/delBasEarlyWarningSetting"})
    @ResponseBody
    public JsonMsg delBasEarlyWarningSetting(Long id) {
        this.basEarlyWarningSettingService.delBasEarlyWarningSetting(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/findEarlyWarningList"})
    @ResponseBody
    public Object findEarlyWarningList(HttpServletRequest request, Long workspaceId, Long themeId, String themeCode, String search) {
        LoginUser loginUser = this.getLoginUser(request);
        return this.basEarlyWarningSettingService.findEarlyWarningList(workspaceId, themeId, themeCode, search, loginUser);
    }

    @RequestMapping(value={"/findEarlyWarningListSum"})
    @ResponseBody
    public Object findEarlyWarningListSum(HttpServletRequest request, Long workspaceId, Long themeId, String themeCode, String search) {
        LoginUser loginUser = this.getLoginUser(request);
        return this.basEarlyWarningSettingService.findEarlyWarningListSum(workspaceId, themeId, themeCode, search, loginUser);
    }

    @RequestMapping(value={"/findEarlyWarningListGroup"})
    @ResponseBody
    public Object findEarlyWarningListGroup(HttpServletRequest request, String themeCode, String search) {
        LoginUser loginUser = this.getLoginUser(request);
        List<Map<String, Object>> list = this.basEarlyWarningSettingService.findEarlyWarningList(null, null, themeCode, search, loginUser);
        Map<String, List<Map>> work = list.stream().collect(Collectors.groupingBy(map -> Objects.toString(map.get("workspaceName"), "") + "_" + Objects.toString(map.get("workspaceId"), "")));
        ArrayList result = new ArrayList();
        List levelResultList = this.basEarlyWarningLevelService.pageAll("", 1, 9999, null, null).getRows();
        work.entrySet().stream().forEach(entry -> {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            String[] arr = ((String)entry.getKey()).split("_");
            dataMap.put("workspaceName", arr[0]);
            dataMap.put("workspaceId", arr[1]);
            if (StringUtil.isNotEmpty(arr[1])) {
                BasModelManage model = this.basModelManageService.findBasModelManage(Long.parseLong(arr[1]));
                dataMap.put("orderNum", model.getOrderNum());
            }
            dataMap.put("num", ((List)entry.getValue()).size());
            List listItem = (List)entry.getValue();
            ArrayList themeResultList = new ArrayList();
            Map<String, List<Map>> themeList = listItem.stream().collect(Collectors.groupingBy(map -> Objects.toString(map.get("themeName"), "") + "_" + Objects.toString(map.get("themeId"), "")));
            themeList.entrySet().stream().forEach(item -> {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                String[] arritem = ((String)item.getKey()).split("_");
                itemMap.put("themeName", arritem[0]);
                itemMap.put("themeId", arritem[1]);
                if (StringUtil.isNotEmpty(arritem[1])) {
                    BasModelManage model = this.basModelManageService.findBasModelManage(Long.parseLong(arritem[1]));
                    itemMap.put("orderNum", model.getOrderNum());
                }
                itemMap.put("num", ((List)item.getValue()).size());
                itemMap.put("title", ((Map)((List)item.getValue()).get(0)).get("settingName"));
                itemMap.put("levelText", ((Map)((List)item.getValue()).get(0)).get("levelText"));
                itemMap.put("levelColor", ((Map)((List)item.getValue()).get(0)).get("levelColor"));
                itemMap.put("warningUrl", ((Map)((List)item.getValue()).get(0)).get("warningUrl"));
                themeResultList.add(itemMap);
            });
            List themeResultListNew = themeResultList.stream().sorted(Comparator.comparing(map -> Long.parseLong(Objects.toString(map.get("orderNum"), "")))).collect(Collectors.toList());
            dataMap.put("themeResultList", themeResultListNew);
            Map<String, List<Map>> levelList = listItem.stream().collect(Collectors.groupingBy(map -> Objects.toString(map.get("levelText"), "")));
            ArrayList lList = new ArrayList();
            levelResultList.stream().forEach(level -> {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.putAll((Map<String, Object>)level);
                List numList = (List)levelList.get(level.get("levelText").toString());
                if (numList != null) {
                    item.put("num", numList.size());
                } else {
                    item.put("num", "0");
                }
                lList.add(item);
            });
            dataMap.put("levelResultList", lList);
            result.add(dataMap);
        });
        return result.stream().sorted(Comparator.comparing(map -> Long.parseLong(Objects.toString(map.get("orderNum"), "")))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/toWarnList"})
    public String toWarnList(Model model, HttpServletRequest request, Long workspaceId, Long themeId, String themeCode, String search) throws Exception {
        LoginUser loginUser = this.getLoginUser(request);
        List<Map<String, Object>> msglist = this.basEarlyWarningSettingService.findEarlyWarningList(workspaceId, themeId, themeCode, search, loginUser);
        for (Map<String, Object> msg : msglist) {
            if (msg.get("dealScript") == null || !StringUtils.isNotBlank((String)msg.get("dealScript").toString())) continue;
            String dealScript = msg.get("dealScript").toString();
            msg.remove("dealScript");
            msg.put("row", UriUtils.encode((String)JSON.toJSONString(msg), (String)"UTF-8"));
            msg.put("dealScript", UriUtils.encode((String)dealScript, (String)"UTF-8"));
        }
        model.addAttribute("msglist", msglist);
        return "/space/warnList";
    }
}

