/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.exceltools;

import com.guochuang.imp.base.common.util.exceltools.TableDataRow;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class TableDataCell {
    private String value;
    private int intValue;
    private double doubleValue;
    private TableDataRow row;
    private int columnIndex;
    private int ColumnType;
    private static DecimalFormat format2 = new DecimalFormat("0.##");
    private int cellStyle = 0;

    public TableDataCell(TableDataRow row) {
        this(-1, row);
    }

    public TableDataCell(int index, TableDataRow row) {
        this.row = row;
        if (index != -1) {
            index = row.getCells().size();
        }
        this.columnIndex = index;
        this.value = "";
    }

    public void setValue(String value) {
        this.value = value;
        this.ColumnType = 0;
    }

    public void setValue(int value) {
        this.value = String.valueOf(value);
        this.intValue = value;
        this.ColumnType = 3;
    }

    public void setValue(double value) {
        this.value = format2.format(value);
        this.ColumnType = 1;
        this.doubleValue = value;
        this.value = String.valueOf(value);
    }

    public void setValue(BigDecimal value) {
        this.value = value.toString();
        if (value.scale() == 2) {
            this.ColumnType = 1;
        } else if (value.scale() == 3) {
            this.ColumnType = 2;
        } else if (value.scale() == 4) {
            this.ColumnType = 24;
        } else if (value.scale() == 5) {
            this.ColumnType = 25;
        } else if (value.scale() == 6) {
            this.ColumnType = 26;
        }
        this.doubleValue = value.doubleValue();
        this.value = String.valueOf(value);
    }

    public String getValue() {
        return this.value;
    }

    public TableDataRow getRow() {
        return this.row;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setCellStyle(int cellStyle) {
        this.cellStyle = cellStyle;
    }

    public int getCellStyle() {
        return this.cellStyle;
    }

    public int getColumnType() {
        return this.ColumnType;
    }

    public void setColumnType(int columnType) {
        this.ColumnType = columnType;
    }
}

