/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.exceltools;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.common.util.exceltools.TableColumn;
import com.guochuang.imp.base.common.util.exceltools.TableData;
import com.guochuang.imp.base.common.util.exceltools.TableDataRow;
import com.guochuang.imp.base.common.util.exceltools.TableHeaderMetaData;
import com.guochuang.imp.util.StringUtil;
import com.ibm.icu.text.SimpleDateFormat;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class ExcelUtils {
    private static final Logger logger = Logger.getLogger(ExcelUtils.class);
    private static FormulaEvaluator evaluator;

    public static Map<String, Object> beanToMap(Object obj) {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if (StringUtils.pathEquals((String)name, (String)"class")) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u7c7b\u578b\u8f6c\u6362\u5931\u8d25!", (Throwable)e);
        }
        return params;
    }

    public static JSONArray sendHttp(HttpServletRequest request, HttpServletResponse response, String realUrl, String queryParams) throws Exception {
        String lines;
        URL url = new URL(realUrl);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        urlConnection.setRequestProperty("Accept-Charset", "utf-8");
        urlConnection.setRequestProperty("Connection", "Keep-Alive");
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Cookie", "JSESSIONID=" + request.getSession().getId());
        StringBuilder param = new StringBuilder();
        if (!StringUtils.isEmpty((Object)queryParams)) {
            String[] queryParamsData;
            String split = ",";
            if (queryParams.contains("&")) {
                split = "&";
            }
            for (String queryParamsString : queryParamsData = queryParams.split(split)) {
                String[] queryParam = queryParamsString.split(":");
                if (!(queryParam != null & queryParam.length > 1)) continue;
                param.append("&");
                param.append(queryParam[0]).append("=").append(queryParam[1]);
            }
        }
        param.append("&exportGrid=Y");
        urlConnection.getOutputStream().write(param.toString().getBytes("utf-8"));
        urlConnection.getOutputStream().flush();
        urlConnection.getOutputStream().close();
        urlConnection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));
        StringBuilder allLines = new StringBuilder();
        while ((lines = reader.readLine()) != null) {
            allLines.append(lines);
        }
        reader.close();
        urlConnection.disconnect();
        if (StringUtils.isEmpty((Object)allLines.toString())) {
            return new JSONArray();
        }
        if (queryParams.contains("page") || allLines.toString().contains("\"rows\":")) {
            JSONObject jsonObject = JSONObject.parseObject((String)allLines.toString());
            JSONArray rows = (JSONArray)jsonObject.get((Object)"rows");
            if (allLines.toString().contains("\"footer\":")) {
                rows.addAll((Collection)((JSONArray)jsonObject.get((Object)"footer")));
            }
            return (JSONArray)jsonObject.get((Object)"rows");
        }
        logger.error((Object)allLines.toString());
        return JSON.parseArray((String)allLines.toString());
    }

    public static TableHeaderMetaData createTableHeader(List<String> list) {
        TableHeaderMetaData headMeta = new TableHeaderMetaData();
        for (String title : list) {
            TableColumn tc = new TableColumn();
            tc.setDisplay(title);
            headMeta.addColumn(tc);
        }
        return headMeta;
    }

    public static TableHeaderMetaData createTableHeader(String[] titls) {
        TableHeaderMetaData headMeta = new TableHeaderMetaData();
        for (String title : titls) {
            TableColumn tc = new TableColumn();
            tc.setDisplay(title);
            tc.setGrouped(true);
            headMeta.addColumn(tc);
        }
        return headMeta;
    }

    public static TableHeaderMetaData createTableHeader(String[] titls, int spanCount) {
        if (spanCount > titls.length) {
            spanCount = titls.length;
        }
        TableHeaderMetaData headMeta = new TableHeaderMetaData();
        for (int i = 0; i < titls.length; ++i) {
            TableColumn tc = new TableColumn();
            tc.setDisplay(titls[i]);
            if (i < spanCount) {
                tc.setGrouped(true);
            }
            headMeta.addColumn(tc);
        }
        return headMeta;
    }

    public static TableHeaderMetaData createTableHeader(String[] parents, HashMap<String, String[]> map) {
        TableHeaderMetaData headMeta = new TableHeaderMetaData();
        TableColumn parentColumn = null;
        TableColumn sonColumn = null;
        for (int i = 0; i < parents.length; ++i) {
            parentColumn = new TableColumn();
            parentColumn.setDisplay(SysUtils.removeHtmlTag(parents[i]));
            if (map != null && map.containsKey(parents[i])) {
                String[] children = map.get(parents[i]);
                for (int j = 0; j < children.length; ++j) {
                    sonColumn = new TableColumn();
                    sonColumn.setDisplay(SysUtils.removeHtmlTag(children[j]));
                    parentColumn.addChild(sonColumn);
                }
            }
            headMeta.addColumn(parentColumn);
        }
        return headMeta;
    }

    public static TableHeaderMetaData createTableHeader(String[] parents, String[][] children) {
        TableHeaderMetaData headMeta = new TableHeaderMetaData();
        TableColumn parentColumn = null;
        TableColumn sonColumn = null;
        for (int i = 0; i < parents.length; ++i) {
            parentColumn = new TableColumn();
            parentColumn.setDisplay(parents[i]);
            if (children != null && children[i] != null) {
                for (int j = 0; j < children[i].length; ++j) {
                    sonColumn = new TableColumn();
                    sonColumn.setDisplay(children[i][j]);
                    parentColumn.addChild(sonColumn);
                }
            }
            headMeta.addColumn(parentColumn);
        }
        return headMeta;
    }

    public static TableData createTableData(List<?> list, TableHeaderMetaData headMeta, String[] fields) {
        TableData td;
        block6: {
            td = new TableData(headMeta);
            TableDataRow row = null;
            if (list.isEmpty()) break block6;
            if (list.get(0).getClass().isArray()) {
                for (Object obj : list) {
                    row = new TableDataRow(td);
                    for (Object o : (Object[])obj) {
                        row.addCell(o);
                    }
                    td.addRow(row);
                }
            } else {
                for (Object obj : list) {
                    row = new TableDataRow(td);
                    Map<String, Object> map = obj instanceof Map ? (Map<String, Object>)obj : ExcelUtils.beanToMap(obj);
                    for (String key : fields) {
                        row.addCell(map.get(key));
                    }
                    td.addRow(row);
                }
            }
        }
        return td;
    }

    public static TableData createTableData(JSONArray jsonArray, TableHeaderMetaData headMeta, String[] fields) {
        TableData td = new TableData(headMeta);
        TableDataRow row = null;
        if (!jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                row = new TableDataRow(td);
                JSONObject jobj = (JSONObject)jsonArray.get(i);
                for (String key : fields) {
                    row.addCell(jobj.get((Object)key));
                }
                td.addRow(row);
            }
        }
        return td;
    }

    public static ZipOutputStream createZipStream(HttpServletResponse response, String zipName) {
        response.reset();
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(zipName + ".zip", "UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"\u5b57\u7b26\u7f16\u7801\u9519\u8bef!", (Throwable)e);
        }
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
        }
        catch (IOException e) {
            logger.error((Object)"\u521b\u5efa\u538b\u7f29\u8f93\u51fa\u6d41\u5931\u8d25!", (Throwable)e);
        }
        return new ZipOutputStream((OutputStream)os);
    }

    public static void copySheetStyle(HSSFWorkbook destwb, HSSFSheet dest, HSSFWorkbook srcwb, HSSFSheet src) {
        if (src == null || dest == null) {
            return;
        }
        dest.setAlternativeExpression(src.getAlternateExpression());
        dest.setAlternativeFormula(src.getAlternateFormula());
        dest.setAutobreaks(src.getAutobreaks());
        dest.setDialog(src.getDialog());
        if (src.getColumnBreaks() != null) {
            int[] nArray = src.getColumnBreaks();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int col = nArray[i];
                dest.setColumnBreak((int)((short)col));
            }
        }
        dest.setDefaultColumnWidth(src.getDefaultColumnWidth());
        dest.setDefaultRowHeight(src.getDefaultRowHeight());
        dest.setDefaultRowHeightInPoints(src.getDefaultRowHeightInPoints());
        dest.setDisplayGuts(src.getDisplayGuts());
        dest.setFitToPage(src.getFitToPage());
        dest.setHorizontallyCenter(src.getHorizontallyCenter());
        dest.setDisplayFormulas(src.isDisplayFormulas());
        dest.setDisplayGridlines(src.isDisplayGridlines());
        dest.setDisplayRowColHeadings(src.isDisplayRowColHeadings());
        dest.setGridsPrinted(src.isGridsPrinted());
        dest.setPrintGridlines(src.isPrintGridlines());
        for (int i = 0; i < src.getNumMergedRegions(); ++i) {
            CellRangeAddress r = src.getMergedRegion(i);
            dest.addMergedRegion(r);
        }
        if (src.getRowBreaks() != null) {
            for (int row : src.getRowBreaks()) {
                dest.setRowBreak(row);
            }
        }
        dest.setRowSumsBelow(src.getRowSumsBelow());
        dest.setRowSumsRight(src.getRowSumsRight());
        short maxcol = 0;
        for (int i = 0; i <= src.getLastRowNum(); ++i) {
            HSSFRow row = src.getRow(i);
            if (row == null || maxcol >= row.getLastCellNum()) continue;
            maxcol = row.getLastCellNum();
        }
        for (short col = 0; col <= maxcol; ++col) {
            if (src.getColumnWidth((int)col) != src.getDefaultColumnWidth()) {
                dest.setColumnWidth((int)col, src.getColumnWidth((int)col));
            }
            dest.setColumnHidden((int)col, src.isColumnHidden((int)col));
        }
    }

    public static String dumpCellStyle(HSSFCellStyle style) {
        StringBuilder sb = new StringBuilder();
        sb.append(style.getHidden()).append(",");
        sb.append(style.getLocked()).append(",");
        sb.append(style.getWrapText()).append(",");
        sb.append(style.getAlignment()).append(",");
        sb.append(style.getBorderBottom()).append(",");
        sb.append(style.getBorderLeft()).append(",");
        sb.append(style.getBorderRight()).append(",");
        sb.append(style.getBorderTop()).append(",");
        sb.append(style.getBottomBorderColor()).append(",");
        sb.append(style.getDataFormat()).append(",");
        sb.append(style.getFillBackgroundColor()).append(",");
        sb.append(style.getFillForegroundColor()).append(",");
        sb.append(style.getFillPattern()).append(",");
        sb.append(style.getIndention()).append(",");
        sb.append(style.getLeftBorderColor()).append(",");
        sb.append(style.getRightBorderColor()).append(",");
        sb.append(style.getRotation()).append(",");
        sb.append(style.getTopBorderColor()).append(",");
        sb.append(style.getVerticalAlignment());
        return sb.toString();
    }

    public static String dumpFont(HSSFFont font) {
        StringBuilder sb = new StringBuilder();
        sb.append(font.getItalic()).append(",").append(font.getStrikeout()).append(",").append(font.getBold()).append(",").append(font.getCharSet()).append(",").append(font.getColor()).append(",").append(font.getFontHeight()).append(",").append(font.getFontName()).append(",").append(font.getTypeOffset()).append(",").append(font.getUnderline());
        return sb.toString();
    }

    public static void copyCellStyle(HSSFWorkbook destwb, HSSFCell dest, HSSFWorkbook srcwb, HSSFCell src) {
        if (src == null || dest == null) {
            return;
        }
        HSSFCellStyle nstyle = ExcelUtils.findStyle(src.getCellStyle(), srcwb, destwb);
        if (nstyle == null) {
            nstyle = destwb.createCellStyle();
            ExcelUtils.copyCellStyle(destwb, nstyle, srcwb, src.getCellStyle());
        }
        dest.setCellStyle(nstyle);
    }

    private static boolean isSameColor(short a, short b, HSSFPalette apalette, HSSFPalette bpalette) {
        if (a == b) {
            return true;
        }
        HSSFColor acolor = apalette.getColor(a);
        HSSFColor bcolor = bpalette.getColor(b);
        if (acolor == null) {
            return true;
        }
        if (bcolor == null) {
            return false;
        }
        return acolor.getHexString().equals(bcolor.getHexString());
    }

    private static short findColor(short index, HSSFWorkbook srcwb, HSSFWorkbook destwb) {
        if (HSSFColor.getIndexHash().containsKey(index)) {
            return index;
        }
        if (index == HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex()) {
            return index;
        }
        HSSFColor color = srcwb.getCustomPalette().getColor(index);
        if (color == null) {
            return index;
        }
        HSSFColor ncolor = destwb.getCustomPalette().findColor((byte)color.getTriplet()[0], (byte)color.getTriplet()[1], (byte)color.getTriplet()[2]);
        if (ncolor != null) {
            return ncolor.getIndex();
        }
        destwb.getCustomPalette().setColorAtIndex(index, (byte)color.getTriplet()[0], (byte)color.getTriplet()[1], (byte)color.getTriplet()[2]);
        return index;
    }

    public static HSSFCellStyle findStyle(HSSFCellStyle style, HSSFWorkbook srcwb, HSSFWorkbook destwb) {
        HSSFPalette srcpalette = srcwb.getCustomPalette();
        HSSFPalette destpalette = destwb.getCustomPalette();
        for (int i = 0; i < destwb.getNumCellStyles(); i = (int)((short)(i + 1))) {
            HSSFCellStyle old = destwb.getCellStyleAt(i);
            if (old == null || style.getAlignment() != old.getAlignment() || style.getBorderBottom() != old.getBorderBottom() || style.getBorderLeft() != old.getBorderLeft() || style.getBorderRight() != old.getBorderRight() || style.getBorderTop() != old.getBorderTop() || !ExcelUtils.isSameColor(style.getBottomBorderColor(), old.getBottomBorderColor(), srcpalette, destpalette) || style.getDataFormat() != old.getDataFormat() || !ExcelUtils.isSameColor(style.getFillBackgroundColor(), old.getFillBackgroundColor(), srcpalette, destpalette) || !ExcelUtils.isSameColor(style.getFillForegroundColor(), old.getFillForegroundColor(), srcpalette, destpalette) || style.getFillPattern() != old.getFillPattern() || style.getHidden() != old.getHidden() || style.getIndention() != old.getIndention() || !ExcelUtils.isSameColor(style.getLeftBorderColor(), old.getLeftBorderColor(), srcpalette, destpalette) || style.getLocked() != old.getLocked() || !ExcelUtils.isSameColor(style.getRightBorderColor(), old.getRightBorderColor(), srcpalette, destpalette) || style.getRotation() != old.getRotation() || !ExcelUtils.isSameColor(style.getTopBorderColor(), old.getTopBorderColor(), srcpalette, destpalette) || style.getVerticalAlignment() != old.getVerticalAlignment() || style.getWrapText() != old.getWrapText()) continue;
            HSSFFont oldfont = destwb.getFontAt(old.getFontIndex());
            HSSFFont font = srcwb.getFontAt(style.getFontIndex());
            if (oldfont.getBold() != font.getBold() || oldfont.getItalic() != font.getItalic() || oldfont.getStrikeout() != font.getStrikeout() || oldfont.getCharSet() != font.getCharSet() || !ExcelUtils.isSameColor(oldfont.getColor(), font.getColor(), srcpalette, destpalette) || oldfont.getFontHeight() != font.getFontHeight() || !oldfont.getFontName().equals(font.getFontName()) || oldfont.getTypeOffset() != font.getTypeOffset() || oldfont.getUnderline() != font.getUnderline()) continue;
            return old;
        }
        return null;
    }

    public static void copyCellStyle(HSSFWorkbook destwb, HSSFCellStyle dest, HSSFWorkbook srcwb, HSSFCellStyle src) {
        if (src == null || dest == null) {
            return;
        }
        dest.setAlignment(src.getAlignment());
        dest.setBorderBottom(src.getBorderBottom());
        dest.setBorderLeft(src.getBorderLeft());
        dest.setBorderRight(src.getBorderRight());
        dest.setBorderTop(src.getBorderTop());
        dest.setBottomBorderColor(ExcelUtils.findColor(src.getBottomBorderColor(), srcwb, destwb));
        dest.setDataFormat(destwb.createDataFormat().getFormat(srcwb.createDataFormat().getFormat(src.getDataFormat())));
        dest.setFillPattern(src.getFillPattern());
        dest.setFillForegroundColor(ExcelUtils.findColor(src.getFillForegroundColor(), srcwb, destwb));
        dest.setFillBackgroundColor(ExcelUtils.findColor(src.getFillBackgroundColor(), srcwb, destwb));
        dest.setHidden(src.getHidden());
        dest.setIndention(src.getIndention());
        dest.setLeftBorderColor(ExcelUtils.findColor(src.getLeftBorderColor(), srcwb, destwb));
        dest.setLocked(src.getLocked());
        dest.setRightBorderColor(ExcelUtils.findColor(src.getRightBorderColor(), srcwb, destwb));
        dest.setRotation(src.getRotation());
        dest.setTopBorderColor(ExcelUtils.findColor(src.getTopBorderColor(), srcwb, destwb));
        dest.setVerticalAlignment(src.getVerticalAlignment());
        dest.setWrapText(src.getWrapText());
        HSSFFont f = srcwb.getFontAt(src.getFontIndex());
        HSSFFont nf = ExcelUtils.findFont(f, srcwb, destwb);
        if (nf == null) {
            nf = destwb.createFont();
            nf.setBold(f.getBold());
            nf.setCharSet(f.getCharSet());
            nf.setColor(ExcelUtils.findColor(f.getColor(), srcwb, destwb));
            nf.setFontHeight(f.getFontHeight());
            nf.setFontHeightInPoints(f.getFontHeightInPoints());
            nf.setFontName(f.getFontName());
            nf.setItalic(f.getItalic());
            nf.setStrikeout(f.getStrikeout());
            nf.setTypeOffset(f.getTypeOffset());
            nf.setUnderline(f.getUnderline());
        }
        dest.setFont(nf);
    }

    private static HSSFFont findFont(HSSFFont font, HSSFWorkbook src, HSSFWorkbook dest) {
        for (short i = 0; i < dest.getNumberOfFonts(); i = (short)(i + 1)) {
            HSSFFont oldfont = dest.getFontAt(i);
            if (font.getBold() != oldfont.getBold() || font.getItalic() != oldfont.getItalic() || font.getStrikeout() != oldfont.getStrikeout() || font.getCharSet() != oldfont.getCharSet() || font.getColor() != oldfont.getColor() || font.getFontHeight() != oldfont.getFontHeight() || !font.getFontName().equals(oldfont.getFontName()) || font.getTypeOffset() != oldfont.getTypeOffset() || font.getUnderline() != oldfont.getUnderline()) continue;
            return oldfont;
        }
        return null;
    }

    public static void copySheet(HSSFWorkbook destwb, HSSFSheet dest, HSSFWorkbook srcwb, HSSFSheet src) {
        if (src == null || dest == null) {
            return;
        }
        ExcelUtils.copySheetStyle(destwb, dest, srcwb, src);
        for (int i = 0; i <= src.getLastRowNum(); ++i) {
            HSSFRow row = src.getRow(i);
            ExcelUtils.copyRow(destwb, dest.createRow(i), srcwb, row);
        }
    }

    public static void copyRow(HSSFWorkbook destwb, HSSFRow dest, HSSFWorkbook srcwb, HSSFRow src) {
        if (src == null || dest == null) {
            return;
        }
        for (int i = 0; i <= src.getLastCellNum(); ++i) {
            if (src.getCell(i) == null) continue;
            HSSFCell cell = dest.createCell(i);
            ExcelUtils.copyCell(destwb, cell, srcwb, src.getCell(i));
        }
    }

    public static void copyCell(HSSFWorkbook destwb, HSSFCell dest, HSSFWorkbook srcwb, HSSFCell src) {
        if (src == null) {
            dest.setCellType(CellType.BLANK);
            return;
        }
        if (src.getCellComment() != null) {
            dest.setCellComment((Comment)src.getCellComment());
        }
        if (src.getCellStyle() != null) {
            HSSFCellStyle nstyle = ExcelUtils.findStyle(src.getCellStyle(), srcwb, destwb);
            if (nstyle == null) {
                nstyle = destwb.createCellStyle();
                ExcelUtils.copyCellStyle(destwb, nstyle, srcwb, src.getCellStyle());
            }
            dest.setCellStyle(nstyle);
        }
        dest.setCellType(src.getCellType());
        switch (src.getCellType()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                dest.setCellValue(src.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                dest.setCellFormula(src.getCellFormula());
                break;
            }
            case ERROR: {
                dest.setCellErrorValue(FormulaError.forInt((byte)src.getErrorCellValue()));
                break;
            }
            case NUMERIC: {
                dest.setCellValue(src.getNumericCellValue());
                break;
            }
            default: {
                dest.setCellValue((RichTextString)new HSSFRichTextString(src.getRichStringCellValue().getString()));
            }
        }
    }

    public static XSSFWorkbook initXSSTemplate(String filePath) {
        XSSFWorkbook wb = new XSSFWorkbook();
        try {
            ClassPathResource res = new ClassPathResource(filePath);
            InputStream is = res.getInputStream();
            OPCPackage pkg = OPCPackage.open((InputStream)is);
            wb = new XSSFWorkbook(pkg);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bfb\u53d6excel\u6a21\u7248\u5931\u8d25!", (Throwable)e);
        }
        return wb;
    }

    public static String formatterStr(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static Double formatterDouble(Object obj) {
        if (obj == null || StringUtils.isEmpty((Object)obj.toString())) {
            return null;
        }
        return Double.parseDouble(obj.toString());
    }

    public static void copyRows(int startRow, int endRow, int position, XSSFSheet sheet) {
        int i;
        CellRangeAddress region = null;
        if (startRow == -1 || endRow == -1) {
            return;
        }
        for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
            region = sheet.getMergedRegion(i);
            if (region.getFirstRow() < startRow || region.getLastRow() > endRow) continue;
            int targetRowFrom = region.getFirstRow() - startRow + position;
            int targetRowTo = region.getLastRow() - startRow + position;
            CellRangeAddress newRegion = region.copy();
            newRegion.setFirstRow(targetRowFrom);
            newRegion.setFirstColumn(region.getFirstColumn());
            newRegion.setLastRow(targetRowTo);
            newRegion.setLastColumn(region.getLastColumn());
            if (newRegion.getNumberOfCells() <= 1) continue;
            sheet.addMergedRegion(newRegion);
        }
        for (i = startRow; i <= endRow; ++i) {
            XSSFRow sourceRow = sheet.getRow(i);
            int columnCount = sourceRow.getLastCellNum();
            if (sourceRow == null) continue;
            XSSFRow newRow = sheet.createRow(position - startRow + i);
            newRow.setHeight(sourceRow.getHeight());
            for (int j = 0; j < columnCount; ++j) {
                XSSFCell templateCell = sourceRow.getCell(j);
                if (templateCell == null) continue;
                XSSFCell newCell = newRow.createCell(j);
                ExcelUtils.copyCell(templateCell, newCell);
            }
        }
    }

    private static void copyCell(XSSFCell srcCell, XSSFCell distCell) {
        distCell.setCellStyle((CellStyle)srcCell.getCellStyle());
        if (srcCell.getCellComment() != null) {
            distCell.setCellComment((Comment)srcCell.getCellComment());
        }
        CellType srcCellType = srcCell.getCellType();
        distCell.setCellType(srcCellType);
        if (srcCellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)srcCell)) {
                distCell.setCellValue(srcCell.getDateCellValue());
            } else {
                distCell.setCellValue(srcCell.getNumericCellValue());
            }
        } else if (srcCellType == CellType.STRING) {
            distCell.setCellValue((RichTextString)srcCell.getRichStringCellValue());
        } else if (srcCellType != CellType.BLANK) {
            if (srcCellType == CellType.BOOLEAN) {
                distCell.setCellValue(srcCell.getBooleanCellValue());
            } else if (srcCellType == CellType.ERROR) {
                distCell.setCellErrorValue(srcCell.getErrorCellValue());
            } else if (srcCellType == CellType.FORMULA) {
                distCell.setCellFormula(srcCell.getCellFormula());
            }
        }
    }

    public static void removeRows(int startRow, int endRow, XSSFSheet sheet) {
        XSSFRow row = null;
        CellRangeAddress region = null;
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        if (startRow == -1 || endRow == -1) {
            return;
        }
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            region = sheet.getMergedRegion(i);
            if (region.getFirstRow() < startRow || region.getLastRow() > endRow) continue;
            indexs.add(i - indexs.size());
        }
        for (Integer i : indexs) {
            sheet.removeMergedRegion(i.intValue());
        }
        for (int j = startRow; j <= endRow; ++j) {
            row = sheet.getRow(j);
            if (row == null) continue;
            sheet.removeRow((Row)row);
        }
    }

    public static SXSSFWorkbook buildMultiHeader(String titleName, String sheetName, SXSSFWorkbook wb, List<Map<String, Object>> cellMapList, List<Map<Object, Object>> detilList, List<Map<String, Object>> cellDetailList) {
        SXSSFRow row;
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.trackAllColumnsForAutoSizing();
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        BigDecimal rows = new BigDecimal(cellMapList.get(cellMapList.size() - 1).get("lev").toString());
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)18);
        font.setBold(true);
        CellStyle cellStyle1 = wb.createCellStyle();
        cellStyle1.setFont(font);
        cellStyle1.setAlignment(HorizontalAlignment.CENTER);
        cellStyle1.setBorderBottom(BorderStyle.THIN);
        cellStyle1.setBorderLeft(BorderStyle.THIN);
        cellStyle1.setBorderTop(BorderStyle.THIN);
        cellStyle1.setBorderRight(BorderStyle.THIN);
        cellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
        SXSSFRow row1 = sheet.createRow(0);
        row1.setHeight((short)500);
        SXSSFCell cell = row1.createCell(0);
        cell.setCellStyle(cellStyle1);
        cell.setCellValue(titleName);
        int index = 4;
        int size = Integer.parseInt(cellMapList.get(0).get("leafsCount").toString());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, index + size));
        SXSSFRow row2 = sheet.createRow(1);
        row2.setHeight((short)500);
        SXSSFCell cell1 = row2.createCell(0);
        SXSSFCell cell2 = row2.createCell(index + size - 1);
        cell1.setCellValue("\u5355\u4f4d:\u5143");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 ");
        String date = sdf.format(new Date());
        cell2.setCellValue("\u5236\u8868\u65e5\u671f\uff1a" + date);
        for (int t = 0; t < rows.intValue(); ++t) {
            sheet.createRow(t + 2).setHeight((short)500);
        }
        SXSSFRow tds = new Integer[rows.intValue() + 2];
        for (int t = 0; t < cellMapList.size(); ++t) {
            SXSSFRow nextrow;
            Integer n;
            int n2 = new BigDecimal(cellMapList.get(t).get("lev").toString()).intValue() + 1;
            if (tds[n2] == null) {
                tds[n2] = 0;
            }
            row = sheet.getRow(n2);
            while (row.getCell(tds[n2].intValue()) != null) {
                SXSSFRow sXSSFRow = tds;
                int n3 = n2;
                Integer n4 = sXSSFRow[n3];
                n = sXSSFRow[n3] = Integer.valueOf(sXSSFRow[n3] + 1);
            }
            sheet.autoSizeColumn(tds[n2].intValue());
            SXSSFRow sXSSFRow = tds;
            int n5 = n2;
            n = sXSSFRow[n5];
            Integer n6 = sXSSFRow[n5] = Integer.valueOf(sXSSFRow[n5] + 1);
            SXSSFCell cellValue = row.createCell(n.intValue());
            cellValue.setCellValue(Objects.toString(cellMapList.get(t).get("name")));
            cellValue.setCellStyle((CellStyle)style);
            BigDecimal rowspan = new BigDecimal(cellMapList.get(t).get("rowspan").toString());
            BigDecimal colspan = new BigDecimal(cellMapList.get(t).get("colspan").toString());
            if (rowspan.intValue() > 1) {
                for (int i = 1; i < rowspan.intValue(); ++i) {
                    if (tds[n2 + i] == null) {
                        tds[n2 + i] = Integer.valueOf(0);
                    }
                    nextrow = sheet.getRow(n2 + i);
                    nextrow.createCell(tds[n2].intValue() - 1).setCellStyle((CellStyle)style);
                }
            }
            if (colspan.intValue() > 1) {
                for (int i = 1; i < colspan.intValue(); ++i) {
                    nextrow = tds;
                    int n7 = n2;
                    SXSSFRow sXSSFRow2 = nextrow[n7];
                    nextrow[n7] = Integer.valueOf(nextrow[n7].intValue() + 1);
                    Integer n8 = nextrow[n7];
                    row.createCell(sXSSFRow2.intValue()).setCellStyle((CellStyle)style);
                }
            }
            if (rowspan.intValue() <= 1 && colspan.intValue() <= 1) continue;
            sheet.addMergedRegion(new CellRangeAddress(n2, n2 + rowspan.intValue() - 1, tds[n2].intValue() - colspan.intValue(), tds[n2].intValue() - 1));
        }
        if (detilList != null && detilList.size() > 0 && cellDetailList != null) {
            String itemVal = "";
            for (int i = 0; i < detilList.size(); ++i) {
                row = detilList.get(i);
                SXSSFRow detailRow = sheet.createRow(rows.intValue() + 2 + i);
                SXSSFCell cellValue = detailRow.createCell(0);
                cellValue.setCellValue((double)(i + 1));
                cellValue.setCellStyle((CellStyle)style);
                SXSSFCell cellValue1 = detailRow.createCell(1);
                if (row.get("empName") != null) {
                    cellValue1.setCellValue(row.get("empName").toString());
                } else {
                    cellValue1.setCellValue("");
                }
                cellValue1.setCellStyle((CellStyle)style);
                SXSSFCell cellValue2 = detailRow.createCell(2);
                if (row.get("deptName") != null) {
                    cellValue2.setCellValue(row.get("deptName").toString());
                } else {
                    cellValue2.setCellValue("");
                }
                cellValue2.setCellStyle((CellStyle)style);
                SXSSFCell cellValue3 = detailRow.createCell(3);
                if (row.get("wageCard") != null) {
                    cellValue3.setCellValue(row.get("wageCard").toString());
                } else {
                    cellValue3.setCellValue("");
                }
                cellValue3.setCellStyle((CellStyle)style);
                for (int d = 0; d < cellDetailList.size(); ++d) {
                    itemVal = cellDetailList.get(d).get("itemId").toString();
                    SXSSFCell cellValueD = detailRow.createCell(d + 4);
                    if (row.get("money" + itemVal) != null) {
                        cellValueD.setCellValue(row.get("money" + itemVal).toString());
                    } else {
                        cellValueD.setCellValue("");
                    }
                    cellValueD.setCellStyle((CellStyle)style);
                }
                SXSSFCell cellValue4 = detailRow.createCell(cellDetailList.size() + 4);
                if (row.get("remark") != null) {
                    cellValue4.setCellValue(row.get("remark").toString());
                } else {
                    cellValue4.setCellValue("");
                }
                cellValue4.setCellStyle((CellStyle)style);
            }
        }
        return wb;
    }

    public static HashMap<Integer, List<HashMap<String, Object>>> getMapListFromExcel(Workbook workbook, int level, int rowDepth, Integer dataLevelRowInterval) {
        HashMap<Integer, List<HashMap<String, Object>>> resultMap = new HashMap<Integer, List<HashMap<String, Object>>>();
        if (dataLevelRowInterval == null) {
            dataLevelRowInterval = rowDepth;
        }
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            ArrayList sheetMapList = new ArrayList();
            Sheet sheet = workbook.getSheetAt(i);
            HashMap<String, String> titleInfo = new HashMap<String, String>();
            for (int m = level; m < level + rowDepth; ++m) {
                Row secondRow = sheet.getRow(m);
                if (secondRow == null) continue;
                for (int k = 0; k < secondRow.getLastCellNum(); ++k) {
                    Cell cell = secondRow.getCell(k);
                    if (!StringUtil.isNotEmpty(ExcelUtils.getCellValueByCell(cell))) continue;
                    titleInfo.put(k + "", ExcelUtils.getCellValueByCell(cell));
                }
            }
            for (int j = level + dataLevelRowInterval; j <= sheet.getLastRowNum(); ++j) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                Row row = sheet.getRow(j);
                for (int n = 0; n < row.getLastCellNum(); ++n) {
                    Cell cell = row.getCell(n);
                    rowMap.put(titleInfo.get(n + "") == null ? "" : titleInfo.get(n + "").toString(), ExcelUtils.getCellValueByCell(cell));
                }
                sheetMapList.add(rowMap);
            }
            resultMap.put(i, sheetMapList);
        }
        return resultMap;
    }

    public static HashMap<Integer, List<HashMap<String, Object>>> getMapListFromExcelNew(Workbook workbook, int level, int rowDepth, Integer dataLevelRowInterval) {
        HashMap<Integer, List<HashMap<String, Object>>> resultMap = new HashMap<Integer, List<HashMap<String, Object>>>();
        if (dataLevelRowInterval == null) {
            dataLevelRowInterval = rowDepth;
        }
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            ArrayList sheetMapList = new ArrayList();
            Sheet sheet = workbook.getSheetAt(i);
            HashMap<String, String> titleInfo = new HashMap<String, String>();
            for (int m = level; m < level + rowDepth; ++m) {
                Row secondRow = sheet.getRow(m);
                if (secondRow == null) continue;
                for (int k = 0; k < secondRow.getLastCellNum(); ++k) {
                    Cell cell = secondRow.getCell(k);
                    if (!StringUtil.isNotEmpty(ExcelUtils.getCellValueByCell(cell))) continue;
                    String title = ExcelUtils.getCellValueByCell(cell);
                    for (Map.Entry entry : titleInfo.entrySet()) {
                        String value = entry.getValue().toString();
                        if (!value.equals(title)) continue;
                        title = title + "1";
                    }
                    titleInfo.put(k + "", title);
                }
            }
            for (int j = level + dataLevelRowInterval; j <= sheet.getLastRowNum(); ++j) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                Row row = sheet.getRow(j);
                for (int n = 0; n < row.getLastCellNum(); ++n) {
                    Cell cell = row.getCell(n);
                    rowMap.put(titleInfo.get(n + "") == null ? "" : titleInfo.get(n + "").toString(), ExcelUtils.getCellValueByCell(cell).replaceAll("\u3000", ""));
                }
                sheetMapList.add(rowMap);
            }
            resultMap.put(i, sheetMapList);
        }
        return resultMap;
    }

    private static String getCellValueByCell(Cell cell) {
        String cellValue = "";
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = evaluator.evaluate(cell).getCellType();
        }
        switch (cellType) {
            case STRING: {
                cellValue = cell.getStringCellValue().trim();
                cellValue = StringUtils.isEmpty((Object)cellValue) ? "" : cellValue;
                break;
            }
            case BOOLEAN: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = DateUtils.dateToStr(cell.getDateCellValue());
                    break;
                }
                cellValue = new DecimalFormat("#.######").format(cell.getNumericCellValue());
                break;
            }
            default: {
                cellValue = "";
            }
        }
        cellValue = StringUtil.escapeHtmlAll(cellValue);
        return cellValue;
    }

    public static SXSSFWorkbook buildMultiHeader(String titleName, String sheetName, SXSSFWorkbook wb, List<Map<String, Object>> cellMapList, List<Map<Object, Object>> detilList, List<Map<String, Object>> cellDetailList, List<Map<String, Object>> dataList, Integer index, String leftNote, boolean isSetRowWidth) {
        SXSSFRow detailRow;
        SXSSFRow row;
        Short columnWidthDefault = 15;
        if (index == null) {
            index = 0;
        }
        if (StringUtil.isEmpty(leftNote)) {
            leftNote = "\u5355\u4f4d:\u5143";
        }
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.trackAllColumnsForAutoSizing();
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        BigDecimal rows = new BigDecimal(Long.valueOf(cellMapList.get(cellMapList.size() - 1).get("lev").toString()));
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)18);
        font.setBold(true);
        CellStyle cellStyle1 = wb.createCellStyle();
        cellStyle1.setFont(font);
        cellStyle1.setAlignment(HorizontalAlignment.CENTER);
        cellStyle1.setBorderBottom(BorderStyle.THIN);
        cellStyle1.setBorderLeft(BorderStyle.THIN);
        cellStyle1.setBorderTop(BorderStyle.THIN);
        cellStyle1.setBorderRight(BorderStyle.THIN);
        cellStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
        SXSSFRow row1 = sheet.createRow(0);
        row1.setHeight((short)500);
        SXSSFCell cell = row1.createCell(0);
        cell.setCellStyle(cellStyle1);
        cell.setCellValue(titleName);
        int size = Integer.parseInt(cellMapList.get(0).get("leafsCount").toString());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, index + size));
        SXSSFRow row2 = sheet.createRow(1);
        row2.setHeight((short)500);
        SXSSFCell cell1 = row2.createCell(0);
        cell1.setCellValue(leftNote);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 1));
        cell1.setCellStyle((CellStyle)style);
        SXSSFCell cell2 = row2.createCell(index + size);
        String date = DateUtils.getDate();
        cell2.setCellValue("\u5236\u8868\u65e5\u671f\uff1a" + date);
        cell2.setCellStyle((CellStyle)style);
        for (int t = 0; t < rows.intValue(); ++t) {
            sheet.createRow(t + 2).setHeight((short)500);
        }
        SXSSFRow tds = new Integer[rows.intValue() + 2];
        for (int t = 0; t < cellMapList.size(); ++t) {
            SXSSFRow nextrow;
            Integer n;
            int n2 = new BigDecimal(Long.valueOf(cellMapList.get(t).get("lev").toString())).intValue() + 1;
            if (tds[n2] == null) {
                tds[n2] = 0;
            }
            row = sheet.getRow(n2);
            while (row.getCell(tds[n2].intValue()) != null) {
                SXSSFRow sXSSFRow = tds;
                int n3 = n2;
                Integer n4 = sXSSFRow[n3];
                n = sXSSFRow[n3] = Integer.valueOf(sXSSFRow[n3] + 1);
            }
            sheet.autoSizeColumn(tds[n2].intValue());
            SXSSFRow sXSSFRow = tds;
            int n5 = n2;
            n = sXSSFRow[n5];
            Integer n6 = sXSSFRow[n5] = Integer.valueOf(sXSSFRow[n5] + 1);
            SXSSFCell cellValue = row.createCell(n.intValue());
            cellValue.setCellValue(Objects.toString(cellMapList.get(t).get("name")));
            cellValue.setCellStyle((CellStyle)style);
            BigDecimal rowspan = new BigDecimal(Long.valueOf(cellMapList.get(t).get("rowspan").toString()));
            BigDecimal colspan = new BigDecimal(Long.valueOf(cellMapList.get(t).get("colspan").toString()));
            if (rowspan.intValue() > 1) {
                for (int i = 1; i < rowspan.intValue(); ++i) {
                    if (tds[n2 + i] == null) {
                        tds[n2 + i] = Integer.valueOf(0);
                    }
                    nextrow = sheet.getRow(n2 + i);
                    nextrow.createCell(tds[n2].intValue() - 1).setCellStyle((CellStyle)style);
                }
            }
            if (colspan.intValue() > 1) {
                for (int i = 1; i < colspan.intValue(); ++i) {
                    nextrow = tds;
                    int n7 = n2;
                    SXSSFRow sXSSFRow2 = nextrow[n7];
                    nextrow[n7] = Integer.valueOf(nextrow[n7].intValue() + 1);
                    Integer n8 = nextrow[n7];
                    row.createCell(sXSSFRow2.intValue()).setCellStyle((CellStyle)style);
                }
            }
            if (rowspan.intValue() <= 1 && colspan.intValue() <= 1) continue;
            sheet.addMergedRegion(new CellRangeAddress(n2, n2 + rowspan.intValue() - 1, tds[n2].intValue() - colspan.intValue(), tds[n2].intValue() - 1));
        }
        if (detilList != null && detilList.size() > 0 && cellDetailList != null) {
            String itemVal = "";
            for (int i = 0; i < detilList.size(); ++i) {
                row = detilList.get(i);
                detailRow = sheet.createRow(rows.intValue() + 2 + i);
                SXSSFCell cellValue = detailRow.createCell(0);
                cellValue.setCellValue((double)(i + 1));
                cellValue.setCellStyle((CellStyle)style);
                SXSSFCell cellValue1 = detailRow.createCell(1);
                if (row.get("empName") != null) {
                    cellValue1.setCellValue(row.get("empName").toString());
                } else {
                    cellValue1.setCellValue("");
                }
                cellValue1.setCellStyle((CellStyle)style);
                SXSSFCell cellValue2 = detailRow.createCell(2);
                if (row.get("deptName") != null) {
                    cellValue2.setCellValue(row.get("deptName").toString());
                } else {
                    cellValue2.setCellValue("");
                }
                cellValue2.setCellStyle((CellStyle)style);
                SXSSFCell cellValue3 = detailRow.createCell(3);
                if (row.get("wageCard") != null) {
                    cellValue3.setCellValue(row.get("wageCard").toString());
                } else {
                    cellValue3.setCellValue("");
                }
                cellValue3.setCellStyle((CellStyle)style);
                for (int d = 0; d < cellDetailList.size(); ++d) {
                    itemVal = cellDetailList.get(d).get("itemId").toString();
                    SXSSFCell cellValueD = detailRow.createCell(d + 4);
                    if (row.get("money" + itemVal) != null) {
                        cellValueD.setCellValue(row.get("money" + itemVal).toString());
                    } else {
                        cellValueD.setCellValue("");
                    }
                    cellValueD.setCellStyle((CellStyle)style);
                }
                SXSSFCell cellValue4 = detailRow.createCell(cellDetailList.size() + 4);
                if (row.get("remark") != null) {
                    cellValue4.setCellValue(row.get("remark").toString());
                } else {
                    cellValue4.setCellValue("");
                }
                cellValue4.setCellStyle((CellStyle)style);
            }
        }
        if (dataList != null && dataList.size() > 0) {
            int basRowLength = 2;
            int otherRowlenght = cellDetailList == null || cellDetailList.size() == 0 ? 0 : cellDetailList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                detailRow = sheet.createRow(basRowLength + otherRowlenght + i + 1);
                int beginIndex = 0;
                for (String key : dataList.get(i).keySet()) {
                    SXSSFCell cellValueDL = detailRow.createCell(beginIndex);
                    cellValueDL.setCellValue(dataList.get(i).get(beginIndex + "") == null ? "" : dataList.get(i).get(beginIndex + "").toString());
                    cellValueDL.setCellStyle((CellStyle)style);
                    ++beginIndex;
                }
            }
        }
        if (isSetRowWidth) {
            for (int m = 0; m < cellMapList.size(); ++m) {
                if (cellMapList.get(m).get("columnWidth") != null && !cellMapList.get(m).get("columnWidth").toString().trim().equals("")) {
                    sheet.setColumnWidth((int)((short)m), Short.parseShort(cellMapList.get(m).get("columnWidth").toString()) * columnWidthDefault);
                    continue;
                }
                sheet.setColumnWidth((int)((short)m), (int)columnWidthDefault.shortValue());
            }
        }
        return wb;
    }
}

