/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import cn.hutool.core.lang.UUID;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.doc.common.persist.FileInfo;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class PictureRotateUtil {
    public static InputStream imageRotate(FileInfo fileinfo, String fileext, String localpath) throws ImageProcessingException, MetadataException, IOException, GEPSBisException {
        File file = new File(localpath + "/temp/temp/" + UUID.randomUUID() + "." + fileext);
        OutputStream os = null;
        try {
            FileUtils.forceMkdir((File)file.getParentFile());
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fileinfo.getIs().read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fileinfo.getIs().close();
        }
        catch (Exception e) {
            throw new GEPSBisException("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        int angel = PictureRotateUtil.getRotateAngleForPhoto(file);
        if (angel > 0) {
            file = PictureRotateUtil.rotateImage(file, angel);
        }
        fileinfo.setIs(new FileInputStream(file));
        fileinfo.setFilesize(file.length());
        return fileinfo.getIs();
    }

    public static File judgeRotate(File in) throws ImageProcessingException, IOException, MetadataException {
        int angel = PictureRotateUtil.getRotateAngleForPhoto(in);
        if (angel > 0 && angel < 360) {
            return PictureRotateUtil.rotateImage(in, angel);
        }
        return in;
    }

    public static int getRotateAngleForPhoto(File in) throws ImageProcessingException, IOException, MetadataException {
        int angel = 0;
        Metadata metadata = ImageMetadataReader.readMetadata((File)in);
        int orientation = 0;
        Iterable iterable = metadata.getDirectories();
        for (Directory dr : iterable) {
            if (dr.getString(274) == null) continue;
            orientation = dr.getInt(274);
        }
        if (orientation == 0 || orientation == 1) {
            angel = 360;
        } else if (orientation == 3) {
            angel = 180;
        } else if (orientation == 6) {
            angel = 90;
        } else if (orientation == 8) {
            angel = 270;
        }
        return angel;
    }

    public static File rotateImage(File file, int angel) throws IOException {
        BufferedImage src = null;
        src = ImageIO.read(file);
        int src_width = src.getWidth(null);
        int src_height = src.getHeight(null);
        Rectangle rect_des = PictureRotateUtil.calcRotatedSize(new Rectangle(new Dimension(src_width, src_height)), angel);
        BufferedImage bi = new BufferedImage(rect_des.width, rect_des.height, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.translate((rect_des.width - src_width) / 2, (rect_des.height - src_height) / 2);
        g2.rotate(Math.toRadians(angel), src_width / 2, src_height / 2);
        g2.drawImage(src, null, null);
        ImageIO.write((RenderedImage)bi, "jpg", file);
        return file;
    }

    public static InputStream bufferedImageToInputStream(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        ByteArrayInputStream input = new ByteArrayInputStream(os.toByteArray());
        return input;
    }

    public static Rectangle calcRotatedSize(Rectangle src, int angel) {
        if (angel > 90) {
            if (angel / 9 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    public static BufferedImage inputImage(String srcImgPath) throws IOException {
        BufferedImage srcImage = null;
        File file = new File(srcImgPath);
        FileInputStream in = new FileInputStream(file);
        byte[] b = new byte[5];
        in.read(b);
        srcImage = ImageIO.read(file);
        in.close();
        return srcImage;
    }
}

