/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.guochuang.imp.base.common.util.SysUtils;
import java.security.MessageDigest;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;

public class Md5Utils {
    public static String generate(String password) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder(16);
        sb.append(r.nextInt(99999999)).append(r.nextInt(99999999));
        int len = sb.length();
        if (len < 16) {
            for (int i = 0; i < 16 - len; ++i) {
                sb.append("0");
            }
        }
        String salt = sb.toString();
        password = Md5Utils.md5HexTwo(password + salt);
        char[] cs = new char[48];
        for (int i = 0; i < 48; i += 3) {
            char c;
            cs[i] = password.charAt(i / 3 * 2);
            cs[i + 1] = c = salt.charAt(i / 3);
            cs[i + 2] = password.charAt(i / 3 * 2 + 1);
        }
        return new String(cs);
    }

    public static boolean verify(String password, String md5) {
        if (md5 == null) {
            return false;
        }
        if (md5.length() < 48) {
            return Md5Utils.md5HexTwo(password).equals(md5);
        }
        char[] cs1 = new char[32];
        char[] cs2 = new char[16];
        for (int i = 0; i < 48; i += 3) {
            cs1[i / 3 * 2] = md5.charAt(i);
            cs1[i / 3 * 2 + 1] = md5.charAt(i + 2);
            cs2[i / 3] = md5.charAt(i + 1);
        }
        String salt = new String(cs2);
        return Md5Utils.md5HexTwo(password + salt).equals(new String(cs1));
    }

    public static String md5HexTwo(String src) {
        return Md5Utils.md5Hex(Md5Utils.md5Hex(src));
    }

    public static String md5Hex(String src) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bs = md5.digest(src.getBytes());
            return new String(new Hex().encode(bs));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String plaintext = "123";
        System.out.println("\u660e\u6587\uff1a" + plaintext);
        System.out.println("\u666e\u901aMD5\u7801\uff1a" + Md5Utils.md5Hex(Md5Utils.md5Hex(plaintext)));
        System.out.println("\u666e\u901aMD5\u7801\uff1a" + Md5Utils.generate(plaintext));
        System.out.println("\u666e\u901aMD5\u7801\uff1a" + SysUtils.md5two(plaintext));
        String ciphertext = Md5Utils.generate(plaintext);
        System.out.println("\u52a0\u76d0\u540eMD5\u7801\uff1a" + ciphertext);
        System.out.println("\u662f\u5426\u662f\u540c\u4e00\u5b57\u7b26\u4e32:" + Md5Utils.verify(plaintext, ciphertext));
        System.out.println("\u662f\u5426\u662f\u540c\u4e00\u5b57\u7b26\u4e32:" + Md5Utils.verify(SysUtils.md5two(plaintext), ciphertext));
        System.out.println("\u662f\u5426\u662f\u540c\u4e00\u5b57\u7b26\u4e32:" + Md5Utils.verify(plaintext, SysUtils.md5two(plaintext)));
    }
}

