/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class FileUtils {
    private static Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final int BIG_DATA_EXPORT_MIN = 50000;
    public static final int BIG_DATA_EXPORT_MAX = 2000000;
    public static HashSet<String> transClassSet = new HashSet();

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, boolean isCreateHeader, HttpServletResponse response) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(isCreateHeader);
        FileUtils.defaultExport(list, pojoClass, fileName, response, title, sheetName);
    }

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, HttpServletResponse response) {
        long startTime = System.currentTimeMillis();
        if (!transClassSet.contains(String.valueOf(pojoClass))) {
            FileUtils.initProperties(pojoClass);
            transClassSet.add(String.valueOf(pojoClass));
        }
        FileUtils.defaultExport(list, pojoClass, fileName, response, title, sheetName);
        log.info("\u6b64\u6587\u4ef6[{}]\u5bfc\u51fa\u8017\u65f6\uff1a{}ms", (Object)fileName, (Object)(System.currentTimeMillis() - startTime));
    }

    public static void exportExcel(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        FileUtils.defaultExport(list, fileName, response);
    }

    private static void defaultExport(List<?> list, Class<?> pojoClass, String fileName, HttpServletResponse response, String title, String sheetName) {
        Workbook workbook = null;
        ExportParams exportParams = new ExportParams(title, sheetName);
        if (list != null && list.size() > 2000000) {
            FileUtils.sizeBeyondError(response);
            return;
        }
        workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(title, sheetName), pojoClass, list);
        if (workbook == null) {
            return;
        }
        FileUtils.downLoadExcel(fileName, response, workbook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            try {
                response.getWriter().println("{\"code\":597,\"message\":\"export error!\",\"data\":\"\"}");
                response.getWriter().flush();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            finally {
                FileUtils.closeIo(response);
            }
        }
    }

    private static void sizeBeyondError(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        try {
            response.getWriter().println("{\"code\":599,\"message\":\"\u6587\u4ef6\u8fc7\u5927!\",\"data\":\"\"}");
            response.getWriter().flush();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            FileUtils.closeIo(response);
        }
    }

    private static void defaultExport(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        Workbook workbook = ExcelExportUtil.exportExcel(list, (ExcelType)ExcelType.HSSF);
        if (workbook != null) {
            // empty if block
        }
        FileUtils.downLoadExcel(fileName, response, workbook);
    }

    public static <T> List<T> importExcel(String filePath, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((File)new File(filePath), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            System.out.println("\u6a21\u7248\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> importExcel(MultipartFile file, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            System.out.println("\u6587\u4ef6\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static synchronized void initProperties(Class cl) {
        try {
            Field[] fields;
            for (Field field : fields = cl.getDeclaredFields()) {
                JsonFormat jsonFormat;
                if (!field.isAnnotationPresent(Excel.class)) continue;
                field.setAccessible(true);
                Excel excel = field.getAnnotation(Excel.class);
                InvocationHandler h = Proxy.getInvocationHandler(excel);
                Field hField = h.getClass().getDeclaredField("memberValues");
                hField.setAccessible(true);
                Map memberValues = (Map)hField.get(h);
                if (!field.isAnnotationPresent(JsonFormat.class) || !StringUtils.isNotEmpty((CharSequence)(jsonFormat = field.getAnnotation(JsonFormat.class)).pattern())) continue;
                memberValues.put("format", jsonFormat.pattern());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void closeIo(HttpServletResponse response) {
        try {
            if (response.getWriter() != null) {
                response.getWriter().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Workbook> getExcelFromRequest(HttpServletRequest request) throws IOException {
        ArrayList<Workbook> workbooks = new ArrayList<Workbook>();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator ite = multiRequest.getFileNames();
            while (ite.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)ite.next());
                InputStream is = file.getInputStream();
                XSSFWorkbook workbook = null;
                if (file.getOriginalFilename().toLowerCase().endsWith("xlsx")) {
                    workbook = new XSSFWorkbook(is);
                } else if (file.getOriginalFilename().toLowerCase().endsWith("xls")) {
                    workbook = new HSSFWorkbook(is);
                }
                workbooks.add((Workbook)workbook);
            }
        }
        return workbooks;
    }

    public static void writeFileForResponse(HttpServletRequest request, HttpServletResponse response, SXSSFWorkbook wb, String titleName, String fileType) throws Exception {
        ServletOutputStream output = response.getOutputStream();
        response.reset();
        String fileName = titleName + "." + fileType;
        String userAgent = request.getHeader("user-agent");
        fileName = userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0 || userAgent.indexOf("Safari") >= 0 ? new String(fileName.getBytes(), "ISO-8859-1") : URLEncoder.encode(fileName, "UTF8");
        response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        response.setContentType("application/msexcel");
        wb.write((OutputStream)output);
        output.close();
    }

    public static File Pdf(ArrayList<String> imageUrllist, String mOutputPdfFileName) {
        Document doc = new Document(PageSize.A4, 0.0f, 0.0f, 0.0f, 0.0f);
        try {
            PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(mOutputPdfFileName));
            doc.open();
            for (int i = 0; i < imageUrllist.size(); ++i) {
                Image png1 = Image.getInstance((String)imageUrllist.get(i));
                doc.setPageSize(new Rectangle(0.0f, 0.0f, png1.getWidth(), png1.getHeight()));
                doc.newPage();
                float heigth = png1.getHeight();
                float width = png1.getWidth();
                int percent = FileUtils.getPercent2(heigth, width);
                png1.setAlignment(1);
                doc.add((Element)png1);
            }
            doc.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File mOutputPdfFile = new File(mOutputPdfFileName);
        if (!mOutputPdfFile.exists()) {
            mOutputPdfFile.deleteOnExit();
            return null;
        }
        return mOutputPdfFile;
    }

    public static int getPercent(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = h > w ? 297.0f / h * 100.0f : 210.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    public static int getPercent2(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = 530.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    public static void imgOfPdf(String filepath, String imgUrl) {
        try {
            ArrayList<String> imageUrllist = new ArrayList<String>();
            String[] imgUrls = imgUrl.split(",");
            for (int i = 0; i < imgUrls.length; ++i) {
                imageUrllist.add(imgUrls[i]);
            }
            String pdfUrl = filepath;
            File file = FileUtils.Pdf(imageUrllist, pdfUrl);
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] streamToByteArray(InputStream is) throws Exception {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = is.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        byte[] array = bos.toByteArray();
        bos.close();
        return array;
    }

    public static void main(String[] args) {
        FileUtils.imgOfPdf("C:\\Users\\40670\\Desktop\\meger.pdf", "C:\\Users\\40670\\Desktop\\logo1.png,C:\\Users\\40670\\Desktop\\IMG_20211010_140213.jpg,C:\\Users\\40670\\Desktop\\158f17ec-572f-48b5-ac72-73bef4830f15.jpg");
    }

    public static void createFolder(String folderPath) {
        File[] files;
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        for (File file : files = folder.listFiles()) {
            if (!file.isDirectory()) continue;
            FileUtils.createFolder(file.getAbsolutePath());
        }
    }
}

