/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateUtils {
    public static final String[] parsePatterns = new String[]{"yyyy/MM/dd", "yyyy-MM-dd", "yyyy-M-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy\u5e74MM\u6708", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM", "yyyy"};

    public static Date parseDate(String dateStr) throws ParseException {
        return org.apache.commons.lang.time.DateUtils.parseDate((String)dateStr, (String[])parsePatterns);
    }

    public static boolean isValidDate(String date) {
        if (date == null || date.length() < 8) {
            return false;
        }
        try {
            String[] format;
            boolean result = false;
            char dateSpace = date.charAt(4);
            if (dateSpace == '-' || dateSpace == '/') {
                format = new String[4];
                String strDateSpace = Character.toString(dateSpace);
                format[0] = "yyyy" + strDateSpace + "MM" + strDateSpace + "dd";
                format[1] = "yyyy" + strDateSpace + "MM" + strDateSpace + "d";
                format[2] = "yyyy" + strDateSpace + "M" + strDateSpace + "dd";
                format[3] = "yyyy" + strDateSpace + "M" + strDateSpace + "d";
            } else {
                format = new String[]{"yyyyMMdd"};
            }
            for (int i = 0; i < format.length; ++i) {
                String aFormat = format[i];
                SimpleDateFormat formatter = new SimpleDateFormat(aFormat);
                formatter.setLenient(false);
                String tmp = formatter.format(formatter.parse(date));
                if (!date.equals(tmp)) continue;
                result = true;
                break;
            }
            return result;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidTime(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatter.setLenient(false);
            formatter.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidMonth(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
            formatter.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidYear(String date) {
        return date != null && date.length() == 4;
    }

    public static Date strToDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToMonthDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToYearDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToDayDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToTime(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToTimeH(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(currentTime);
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    public static String dateToStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String parse(Date date, String fmt) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(fmt);
        return formatter.format(date);
    }

    public static String timeToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(date);
    }

    public static String getNow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static String getDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static String getTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static int getYear() {
        Date Now = new Date();
        return DateUtils.getYear(Now);
    }

    public static int getYear(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        return Integer.parseInt(formatter.format(date));
    }

    public static String getCurYear() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yy");
        return formatter.format(date);
    }

    public static int getMonth() {
        Date Now = new Date();
        return DateUtils.getMonth(Now);
    }

    public static int getMonth(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("M");
        return Integer.parseInt(formatter.format(date));
    }

    public static String getMonthFirstDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-01");
        return formatter.format(date);
    }

    public static String getYearMonth() {
        Date Now = new Date();
        return DateUtils.getYearAndMonth(Now);
    }

    public static String getYearAndMonth(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        return formatter.format(date);
    }

    public static String getMonthMaxDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int maxDay = cal.getActualMaximum(5);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-" + maxDay);
        return formatter.format(date);
    }

    public static String getYearFirstDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-01-01");
        return formatter.format(date);
    }

    public static String getYearMaxDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-12-31");
        return formatter.format(date);
    }

    public static String dateToMonthStr(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        return formatter.format(date);
    }

    public static int getDay() {
        Date Now = new Date();
        return DateUtils.getDay(Now);
    }

    public static int getDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("d");
        return Integer.parseInt(formatter.format(date));
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSecond(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date addDay(Date date, int addCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.strToDate(DateUtils.dateToStr(date)));
        calendar.add(5, addCount);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int addCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.strToDate(DateUtils.dateToStr(date)));
        calendar.add(2, addCount);
        return calendar.getTime();
    }

    public static Date strToDate(String date, String dateFormat) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static int differenceDays(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return -1;
        }
        Float days = new Float((endDate.getTime() - startDate.getTime()) / 86400000L);
        return days.intValue();
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        StringBuffer poorDate = new StringBuffer();
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        if (day > 0L) {
            poorDate.append(day + "\u5929");
        }
        if (hour > 0L) {
            poorDate.append(hour + "\u5c0f\u65f6");
        }
        if (min > 0L) {
            poorDate.append(min + "\u5206\u949f");
        }
        if (day <= 0L && hour <= 0L && min <= 0L) {
            poorDate.append(sec + "\u79d2");
        }
        return poorDate.toString();
    }

    public static long getDatePoorDays(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long diff = endDate.getTime() - nowDate.getTime();
        return diff / nd;
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateUtils.getDatePoorDays(DateUtils.strToMonthDate("2017-06"), DateUtils.strToMonthDate("2017-05")));
    }

    public static Date getMonthMinTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getMonthMaxTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int maxDay = cal.getActualMaximum(5);
        cal.set(5, maxDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getMonthDateByDay(int day) {
        Date curDate = DateUtils.formatterMonthByDay(new Date(), day);
        try {
            curDate = DateUtils.strToDate(DateUtils.getMonthFirstDay(curDate));
        }
        catch (ParseException e) {
            curDate = new Date();
        }
        return curDate;
    }

    public static String getMonthByDay(int day) {
        return DateUtils.dateToMonthStr(DateUtils.formatterMonthByDay(new Date(), day));
    }

    public static Date formatterMonthByDay(Date date, int day) {
        try {
            if (DateUtils.getDay(date) >= day) {
                date = DateUtils.addMonth(date, 1);
            }
        }
        catch (ParseException e) {
            date = new Date();
        }
        return date;
    }

    public static boolean checkNowMonth(Date checkMonth) {
        return DateUtils.dateToMonthStr(new Date()).equals(DateUtils.dateToMonthStr(checkMonth));
    }

    public static int getMonthWeek(Date curDate) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(curDate);
        return rightNow.get(4);
    }
}

