/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class CollectionUtils {
    public static boolean isNotEmpty(Collection collection) {
        return collection != null && collection.size() > 0;
    }

    public static boolean isEmpty(Collection collection) {
        return !CollectionUtils.isNotEmpty(collection);
    }

    public static boolean isNotEmpty(Object[] objs) {
        return objs != null && objs.length > 0;
    }

    public static boolean isEmpty(Object[] objs) {
        return !CollectionUtils.isNotEmpty(objs);
    }

    public static String joinBySplit(Collection<String> collection, String split) {
        String result = "";
        if (CollectionUtils.isEmpty(collection) || split == null) {
            return result;
        }
        StringBuffer buffer = new StringBuffer();
        for (String s : collection) {
            buffer.append(s + split);
        }
        result = buffer.toString();
        if (result.endsWith(split)) {
            result = result.substring(0, result.length() - split.length());
        }
        return result;
    }

    public static String joinSplit(Collection<? extends Number> collection, String split) {
        String result = "";
        if (CollectionUtils.isEmpty(collection) || split == null) {
            return result;
        }
        StringBuffer buffer = new StringBuffer();
        for (Number number : collection) {
            buffer.append(number.toString() + split);
        }
        result = buffer.toString();
        if (result.endsWith(split)) {
            result = result.substring(0, result.length() - split.length());
        }
        return result;
    }

    public static void setMapSpecialCharacterForNull(Map<String, Object> map, String specialCharacter) {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (map.get(key) != null) continue;
            map.put(key, specialCharacter);
        }
    }

    public static void setMapSpecialCharacterForNull(Map<String, Object> map, String needReplacedString, String specialCharacter, List<String> listKey) {
        if (map == null || map.size() == 0 || listKey == null || listKey.size() == 0 || specialCharacter == null || needReplacedString == null) {
            return;
        }
        for (int i = 0; i < listKey.size(); ++i) {
            if (!map.containsKey(listKey.get(i)) || map.get(listKey.get(i)) != null && !needReplacedString.equals(map.get(listKey.get(i)).toString())) continue;
            map.put(listKey.get(i), specialCharacter);
        }
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u7248\u672c:8+64");
        list.add("\u989c\u8272\uff1a\u9ed1\u8272");
        String res = CollectionUtils.joinBySplit(list, "");
        System.out.println(res);
        String s = StringUtils.collectionToDelimitedString(list, (String)"");
        System.out.println(s);
        ArrayList<Long> list2 = new ArrayList<Long>();
        list2.add(111223L);
        list2.add(22312L);
        String s1 = CollectionUtils.joinSplit(list2, ",");
        System.out.println(s1);
    }
}

