/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.spring;

import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.base.common.util.Reflections;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.entity.BasMessage;
import com.guochuang.imp.base.entity.BasProcessForwardingd;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.base.service.CreateCodeService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.entity.WfProcessinstRoll;
import com.guochuang.imp.workflow.entity.WfWorkitemAdd;
import com.guochuang.imp.workflow.service.FlowUtilService;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.Version;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.util.StringUtils;

public class MyJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(MyJpaRepository.class);
    private static Map<String, Method> cachedMethod = new ConcurrentHashMap<String, Method>();
    private CreateCodeService createCodeService;
    private CommonService commonService;

    @Autowired
    public MyJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    public <S extends T> S save(S entity) {
        this.prepareSave(entity);
        return (S)super.save(entity);
    }

    public <S extends T> void prepareSave(S entity) {
        block15: {
            Class<?> cls;
            Method method;
            if (entity instanceof HibernateProxy) {
                entity = Hibernate.unproxy(entity);
            }
            if ((method = this.findGetIdMethod(cls = entity.getClass())) == null) {
                logger.error("\u5728Class {} \u4e2d\u672a\u627e\u5230id\u5b57\u6bb5\u7684get\u65b9\u6cd5\uff0c\u65e0\u6cd5\u8fdb\u884c\u9884\u5904\u7406\uff01\u8bf7\u68c0\u67e5Entity\u8bbe\u8ba1\u662f\u5426\u6b63\u786e\uff01", cls);
                return;
            }
            try {
                Object id = method.invoke(entity, new Object[0]);
                if (!(Reflections.getAccessibleField(entity, "modifyAccount") == null || Reflections.getAccessibleField(entity, "auditedModify") != null && "Y".equals(BeanUtils.getProperty(entity, (String)"auditedModify")))) {
                    BeanUtils.setProperty(entity, (String)"modifyAccount", (Object)SysUtils.getLoginAccountId());
                    try {
                        Method modifyMethod = cls.getMethod("getModifyTime", new Class[0]);
                        if (!modifyMethod.isAnnotationPresent(Version.class)) {
                            BeanUtils.setProperty(entity, (String)"modifyTime", (Object)new Date());
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6267\u884c\u53cd\u5c04\u65b9\u6cd5\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((Object)id)) {
                    this.prepareInsert(entity);
                    break block15;
                }
                try {
                    ProcessInstance instance;
                    ApplicationContext ac = SpringContextHolder.getApplicationContext();
                    String processinstid = BeanUtils.getProperty(entity, (String)"processinstid");
                    if (!(BasMessage.class.isInstance(entity) || WfWorkitemAdd.class.isInstance(entity) || BasProcessForwardingd.class.isInstance(entity) || WfProcessinstRoll.class.isInstance(entity) || processinstid == null || (instance = ((FlowUtilService)ac.getBean(FlowUtilService.class)).getProcInstService().findProcessById(Long.parseLong(processinstid))) == null || instance.getCurrentState() != 7)) {
                        throw new RuntimeException("\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u4eba\u5458\u66f4\u65b0\uff0c\u8bf7\u60a8\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
                    }
                    if (!BasMessage.class.isInstance(entity) && !WfWorkitemAdd.class.isInstance(entity) && !BasProcessForwardingd.class.isInstance(entity) && "N".equals(BeanUtils.getProperty(entity, (String)"isUse")) && processinstid != null) {
                        ((FlowUtilService)ac.getBean(FlowUtilService.class)).getProcInstService().terminateProcess(Long.parseLong(processinstid));
                    }
                    if (!(processinstid == null || BasMessage.class.isInstance(entity) || WfWorkitemAdd.class.isInstance(entity) || BasProcessForwardingd.class.isInstance(entity) || FlowUtilService.FINISHED_PROCESS.getIfPresent((Object)Long.parseLong(processinstid)) == null)) {
                        logger.warn("\u6d41\u7a0b\u5df2\u5ba1\u6838\u5b8c\u6210,\u91cd\u590d\u63d0\u4ea4\u8bf7\u6c42\uff0c\u6d41\u7a0bid\uff1a" + processinstid);
                        throw new RuntimeException("\u6d41\u7a0b\u5df2\u5ba1\u6838\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error("\u6267\u884c\u53cd\u5c04\u65b9\u6cd5\u5931\u8d25\uff01", (Throwable)e);
                throw new RuntimeException("\u4fdd\u5b58\u5904\u7406\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("\u4fdd\u5b58\u5904\u7406\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public <S extends T> void prepareInsert(S entity) {
        try {
            if (Reflections.getAccessibleField(entity, "createAccount") != null) {
                if (StringUtil.isEmpty(BeanUtils.getProperty(entity, (String)"createAccount"))) {
                    BeanUtils.setProperty(entity, (String)"createAccount", (Object)SysUtils.getLoginAccountId());
                }
                if (BeanUtils.getProperty(entity, (String)"createTime") == null) {
                    BeanUtils.setProperty(entity, (String)"createTime", (Object)new Date());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4eba\u521b\u5efa\u65f6\u95f4\u6ce8\u5165\u5931\u8d25\uff01");
        }
        if (this.createCodeService == null) {
            this.createCodeService = SpringContextHolder.getBean(CreateCodeService.class);
        }
        this.createCodeService.createCode(entity);
    }

    public static String getColumnName(Class<?> classtype, Class<? extends Annotation> annotationType) {
        Method[] methods = classtype.getMethods();
        String columnName = "";
        for (Method method : methods) {
            Column columnAnno;
            if (!method.isAnnotationPresent(annotationType) || (columnAnno = method.getAnnotation(Column.class)) == null) continue;
            columnName = columnAnno.name();
            return columnName;
        }
        logger.error("\u5728{}\u4e2d\u627e\u4e0d\u5230\u540c\u65f6\u5e26\u6709{}\u6ce8\u89e3\u548cColumn\u6ce8\u89e3\u7684\u5b57\u6bb5\uff01", (Object)classtype.getName(), (Object)annotationType.getName());
        return columnName;
    }

    private Method findGetIdMethod(Class<?> cls) {
        String className = cls.getName();
        Method method = cachedMethod.get(className);
        if (method != null) {
            logger.debug("\u627e\u5230\u65b9\u6cd5\u7f13\u5b58\uff1a{}", (Object)method.getName());
            return method;
        }
        if (this.commonService == null) {
            this.commonService = SpringContextHolder.getBean(CommonService.class);
        }
        String primeryKeyName = DBPropertyUtil.columnToProperty2(this.commonService.getPK(DBPropertyUtil.underscoreName(cls.getSimpleName()))).toLowerCase();
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!("get" + primeryKeyName).equals(method.getName().toLowerCase())) continue;
            cachedMethod.put(className, method);
            return method;
        }
        return null;
    }
}

