/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.shiro;

import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.BasMenuButton;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasEmpService;
import com.guochuang.imp.base.service.BasMenuButtonService;
import com.guochuang.imp.base.service.BasMenuService;
import com.guochuang.imp.base.service.BasRolesAccountService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroRealm
extends AuthorizingRealm {
    @Autowired
    private BasEmpService basEmpService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasMenuService basMenuService;
    @Autowired
    private BasMenuButtonService basmenubtnService;
    @Autowired
    private BasRolesAccountService basRolesAccountService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String currentUsername = (String)super.getAvailablePrincipal(principals);
        Long accountId = Long.parseLong(principals.getPrimaryPrincipal().toString());
        List menus = this.basMenuService.getmenu(accountId, null);
        ArrayList<String> permissionList = new ArrayList<String>();
        for (Object p : menus) {
            Map menu = (Map)p;
            if (menu.get("MENU_ADDR") == null || !StringUtils.isNotBlank((CharSequence)menu.get("MENU_ADDR").toString()) || !menu.get("MENU_ADDR").toString().startsWith("/")) continue;
            permissionList.add(StringUtils.split((String)menu.get("MENU_ADDR").toString(), (String)"?")[0]);
        }
        List<BasMenuButton> btns = this.basmenubtnService.findByAccountId(accountId);
        for (BasMenuButton btn : btns) {
            if (!StringUtils.isNotBlank((CharSequence)btn.getButtonHtmlid())) continue;
            permissionList.add(btn.getButtonHtmlid());
        }
        SimpleAuthorizationInfo simpleAuthorInfo = new SimpleAuthorizationInfo();
        if ("0".equals(currentUsername) && StringUtils.isNotEmpty((CharSequence)currentUsername)) {
            simpleAuthorInfo.addStringPermission("admin:manage");
        }
        List<Map<String, Object>> roles = this.basRolesAccountService.findRolesByAccountId(accountId);
        for (Map<String, Object> role : roles) {
            if (role.get("ROLE_CODE") == null) continue;
            simpleAuthorInfo.addRole(role.get("ROLE_CODE").toString());
        }
        simpleAuthorInfo.addStringPermissions(permissionList);
        return simpleAuthorInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        BasEmpAccount account = this.basEmpAccountService.findEmpAccountById(Long.parseLong(token.getUsername()));
        BasEmp emp = this.basEmpService.findEmpByempId(account.getEmpId());
        if (account != null && emp != null) {
            SimpleAuthenticationInfo authcInfo = new SimpleAuthenticationInfo((Object)token.getUsername(), (Object)token.getPassword(), "user");
            return authcInfo;
        }
        throw new IncorrectCredentialsException();
    }
}

