/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.license.spring.boot.autoconfigure;

import com.guochuang.license.spring.boot.autoconfigure.ContentModifierFilter;
import com.guochuang.license.spring.boot.autoconfigure.LicenseVerify;
import com.guochuang.license.spring.boot.autoconfigure.properties.LicenseProperties;
import javax.servlet.Filter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.Scheduled;

@EnableConfigurationProperties(value={LicenseProperties.class})
public class LicenseAutoConfigure {
    private final LicenseProperties properties;
    private LicenseVerify licenseVerify;

    public LicenseAutoConfigure(LicenseProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod="install", destroyMethod="unInstall")
    public LicenseVerify licenseVerify() {
        this.licenseVerify = new LicenseVerify(this.properties.getSubject(), this.properties.getPublicAlias(), this.properties.getStorePass(), this.properties.getLicensePath(), this.properties.getPublicKeysStorePath());
        return this.licenseVerify;
    }

    @Bean
    public FilterRegistrationBean<ContentModifierFilter> contentModifierFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new ContentModifierFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Scheduled(cron="0 0/2 * * * ?")
    public void startValidateLicense() {
        this.validateLicense();
    }

    private void validateLicense() {
        if (!this.licenseVerify.verify()) {
            // empty if block
        }
    }

    public LicenseProperties getProperties() {
        return this.properties;
    }

    public LicenseVerify getLicenseVerify() {
        return this.licenseVerify;
    }

    public void setLicenseVerify(LicenseVerify licenseVerify) {
        this.licenseVerify = licenseVerify;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicenseAutoConfigure)) {
            return false;
        }
        LicenseAutoConfigure other = (LicenseAutoConfigure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LicenseProperties this$properties = this.getProperties();
        LicenseProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        LicenseVerify this$licenseVerify = this.getLicenseVerify();
        LicenseVerify other$licenseVerify = other.getLicenseVerify();
        return !(this$licenseVerify == null ? other$licenseVerify != null : !this$licenseVerify.equals(other$licenseVerify));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LicenseAutoConfigure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LicenseProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        LicenseVerify $licenseVerify = this.getLicenseVerify();
        result = result * 59 + ($licenseVerify == null ? 43 : $licenseVerify.hashCode());
        return result;
    }

    public String toString() {
        return "LicenseAutoConfigure(properties=" + this.getProperties() + ", licenseVerify=" + this.getLicenseVerify() + ")";
    }
}

