/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.license.spring.boot.autoconfigure;

import cn.hutool.core.date.DateUtil;
import com.guochuang.license.spring.boot.autoconfigure.CustomKeyStoreParam;
import com.guochuang.license.spring.boot.autoconfigure.LicenseManagerHolder;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class LicenseVerify {
    private static final Logger log = LoggerFactory.getLogger(LicenseVerify.class);
    private final String subject;
    private final String publicAlias;
    private final String storePass;
    private final String licensePath;
    private final String publicKeysStorePath;
    private boolean installSuccess;
    private Long restDay;

    public LicenseVerify(String subject, String publicAlias, String storePass, String licensePath, String publicKeysStorePath) {
        this.subject = subject;
        this.publicAlias = publicAlias;
        this.storePass = storePass;
        this.licensePath = licensePath;
        this.publicKeysStorePath = publicKeysStorePath;
    }

    public LicenseContent install() {
        LicenseContent result = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            LicenseManager licenseManager = LicenseManagerHolder.getInstance(this.initLicenseParam());
            licenseManager.uninstall();
            ClassPathResource licensePathResource = new ClassPathResource(this.licensePath);
            result = licenseManager.install(licensePathResource.getFile());
            this.installSuccess = true;
            this.restDay = DateUtil.betweenDay((Date)new Date(), (Date)result.getNotAfter(), (boolean)true);
            log.info(MessageFormat.format("\u8bc1\u4e66\u5b89\u88c5\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", format.format(result.getNotBefore()), format.format(result.getNotAfter())));
        }
        catch (Exception e) {
            this.installSuccess = false;
            this.restDay = 0L;
            log.error("\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25\uff01", (Throwable)e);
        }
        return result;
    }

    public void unInstall() {
        if (this.installSuccess) {
            try {
                LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
                licenseManager.uninstall();
                log.info("------------------------------- \u8bc1\u4e66\u5378\u8f7d\u6210\u529f -------------------------------");
            }
            catch (Exception e) {
                log.error("------------------------------- \u8bc1\u4e66\u5378\u8f7d\u5931\u8d25 -------------------------------");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean verify() {
        LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            LicenseContent licenseContent = licenseManager.verify();
            this.restDay = DateUtil.betweenDay((Date)new Date(), (Date)licenseContent.getNotAfter(), (boolean)true);
            log.info(MessageFormat.format("\u8bc1\u4e66\u6821\u9a8c\u901a\u8fc7\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", format.format(licenseContent.getNotBefore()), format.format(licenseContent.getNotAfter())));
            return true;
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    private LicenseParam initLicenseParam() {
        Preferences preferences = Preferences.userNodeForPackage(LicenseVerify.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(this.storePass);
        CustomKeyStoreParam publicStoreParam = new CustomKeyStoreParam(LicenseVerify.class, this.publicKeysStorePath, this.publicAlias, this.storePass, null);
        return new DefaultLicenseParam(this.subject, preferences, (KeyStoreParam)publicStoreParam, (CipherParam)cipherParam);
    }

    public boolean isInstallSuccess() {
        return this.installSuccess;
    }

    public void setInstallSuccess(boolean installSuccess) {
        this.installSuccess = installSuccess;
    }

    public Long getRestDay() {
        return this.restDay;
    }

    public void setRestDay(Long restDay) {
        this.restDay = restDay;
    }
}

